/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.vafile;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.LPNormDistanceFunction;
import de.lmu.ifi.dbs.elki.index.AbstractRefiningIndex;
import de.lmu.ifi.dbs.elki.index.IndexFactory;
import de.lmu.ifi.dbs.elki.index.KNNIndex;
import de.lmu.ifi.dbs.elki.index.RangeIndex;
import de.lmu.ifi.dbs.elki.index.vafile.VALPNormDistance;
import de.lmu.ifi.dbs.elki.index.vafile.VectorApproximation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.persistent.AbstractPageFileFactory;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.DoubleMaxHeap;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Title(value="An approximation based data structure for similarity search")
@Reference(authors="Weber, R. and Blott, S.", title="An approximation based data structure for similarity search", booktitle="Report TR1997b, ETH Zentrum, Zurich, Switzerland", url="http://citeseerx.ist.psu.edu/viewdoc/download?doi=10.1.1.40.480&rep=rep1&type=pdf")
public class VAFile<V extends NumberVector>
extends AbstractRefiningIndex<V>
implements KNNIndex<V>,
RangeIndex<V> {
    private static final Logging LOG = Logging.getLogger(VAFile.class);
    private List<VectorApproximation> vectorApprox;
    private int partitions;
    private double[][] splitPositions;
    int pageSize;
    int scans;

    public VAFile(int n, Relation<V> relation, int n2) {
        super(relation);
        this.partitions = n2;
        this.pageSize = n;
        this.scans = 0;
        this.vectorApprox = new ArrayList<VectorApproximation>();
    }

    @Override
    public void initialize() {
        this.setPartitions(this.relation);
        DBIDIter dBIDIter = this.relation.iterDBIDs();
        while (dBIDIter.valid()) {
            DBID dBID = DBIDUtil.deref(dBIDIter);
            this.vectorApprox.add(this.calculateApproximation(dBID, (NumberVector)this.relation.get(dBID)));
            dBIDIter.advance();
        }
    }

    public void setPartitions(Relation<V> relation) throws IllegalArgumentException {
        if (Math.log(this.partitions) / Math.log(2.0) != (double)((int)(Math.log(this.partitions) / Math.log(2.0)))) {
            throw new IllegalArgumentException("Number of partitions must be a power of 2!");
        }
        int n = RelationUtil.dimensionality(relation);
        int n2 = relation.size();
        this.splitPositions = new double[n][this.partitions + 1];
        for (int i = 0; i < n; ++i) {
            double[] dArray = new double[n2];
            int n3 = 0;
            DBIDIter dBIDIter = relation.iterDBIDs();
            while (dBIDIter.valid()) {
                dArray[n3] = ((NumberVector)relation.get(dBIDIter)).doubleValue(i);
                ++n3;
                dBIDIter.advance();
            }
            Arrays.sort(dArray);
            for (int j = 0; j < this.partitions; ++j) {
                int n4 = (int)((double)(j * n2) / (double)this.partitions);
                this.splitPositions[i][j] = dArray[n4];
            }
            this.splitPositions[i][this.partitions] = dArray[n2 - 1] + 1.0E-6;
        }
    }

    public VectorApproximation calculateApproximation(DBID dBID, V v) {
        int[] nArray = new int[v.getDimensionality()];
        for (int i = 0; i < this.splitPositions.length; ++i) {
            double d = v.doubleValue(i);
            int n = this.splitPositions[i].length - 1;
            if (d < this.splitPositions[i][0]) {
                nArray[i] = 0;
                if (dBID == null) continue;
                LOG.warning("Vector outside of VAFile grid!");
                continue;
            }
            if (d > this.splitPositions[i][n]) {
                nArray[i] = n - 1;
                if (dBID == null) continue;
                LOG.warning("Vector outside of VAFile grid!");
                continue;
            }
            int n2 = Arrays.binarySearch(this.splitPositions[i], d);
            nArray[i] = n2 = n2 >= 0 ? n2 : -n2 - 2;
        }
        return new VectorApproximation(dBID, nArray);
    }

    public long getScannedPages() {
        int n = this.pageSize / VectorApproximation.byteOnDisk(this.splitPositions.length, this.partitions);
        int n2 = (int)Math.ceil((double)this.vectorApprox.size() / (1.0 * (double)n));
        return n2 * this.scans;
    }

    @Override
    public Logging getLogger() {
        return LOG;
    }

    @Override
    public void logStatistics() {
        super.logStatistics();
        LOG.statistics("scanned pages:" + this.getScannedPages());
    }

    @Override
    public String getLongName() {
        return "VA-file index";
    }

    @Override
    public String getShortName() {
        return "va-file";
    }

    @Override
    public KNNQuery<V> getKNNQuery(DistanceQuery<V> distanceQuery, Object ... objectArray) {
        DistanceFunction<V> distanceFunction = distanceQuery.getDistanceFunction();
        if (distanceFunction instanceof LPNormDistanceFunction) {
            double d = ((LPNormDistanceFunction)distanceFunction).getP();
            return new VAFileKNNQuery(distanceQuery, d);
        }
        return null;
    }

    @Override
    public RangeQuery<V> getRangeQuery(DistanceQuery<V> distanceQuery, Object ... objectArray) {
        DistanceFunction<V> distanceFunction = distanceQuery.getDistanceFunction();
        if (distanceFunction instanceof LPNormDistanceFunction) {
            double d = ((LPNormDistanceFunction)distanceFunction).getP();
            return new VAFileRangeQuery(distanceQuery, d);
        }
        return null;
    }

    public static class Factory<V extends NumberVector>
    implements IndexFactory<V, VAFile<V>> {
        public static final OptionID PARTITIONS_ID = new OptionID("vafile.partitions", "Number of partitions to use in each dimension.");
        int pagesize = 1;
        int numpart = 2;

        public Factory(int n, int n2) {
            this.pagesize = n;
            this.numpart = n2;
        }

        @Override
        public VAFile<V> instantiate(Relation<V> relation) {
            return new VAFile<V>(this.pagesize, relation, this.numpart);
        }

        @Override
        public TypeInformation getInputTypeRestriction() {
            return TypeUtil.NUMBER_VECTOR_FIELD;
        }

        public static class Parameterizer
        extends AbstractParameterizer {
            int pagesize = 1;
            int numpart = 2;

            @Override
            protected void makeOptions(Parameterization parameterization) {
                super.makeOptions(parameterization);
                IntParameter intParameter = new IntParameter(AbstractPageFileFactory.Parameterizer.PAGE_SIZE_ID, 1024);
                intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
                if (parameterization.grab(intParameter)) {
                    this.pagesize = (Integer)intParameter.getValue();
                }
                IntParameter intParameter2 = new IntParameter(PARTITIONS_ID);
                intParameter2.addConstraint(CommonConstraints.GREATER_THAN_ONE_INT);
                if (parameterization.grab(intParameter2)) {
                    this.numpart = (Integer)intParameter2.getValue();
                }
            }

            @Override
            protected Factory<?> makeInstance() {
                return new Factory(this.pagesize, this.numpart);
            }
        }
    }

    public class VAFileKNNQuery
    extends AbstractRefiningIndex.AbstractKNNQuery {
        final double p;

        public VAFileKNNQuery(DistanceQuery<V> distanceQuery, double d) {
            super(distanceQuery);
            this.p = d;
        }

        @Override
        public KNNList getKNNForObject(V v, int n) {
            double d;
            Object object;
            VectorApproximation vectorApproximation = VAFile.this.calculateApproximation(null, v);
            VALPNormDistance vALPNormDistance = new VALPNormDistance(this.p, VAFile.this.splitPositions, (NumberVector)v, vectorApproximation);
            DoubleMaxHeap doubleMaxHeap = new DoubleMaxHeap(n + 1);
            double d2 = Double.POSITIVE_INFINITY;
            ModifiableDoubleDBIDList modifiableDoubleDBIDList = DBIDUtil.newDistanceDBIDList(VAFile.this.vectorApprox.size());
            ++VAFile.this.scans;
            for (int i = 0; i < VAFile.this.vectorApprox.size(); ++i) {
                object = (VectorApproximation)VAFile.this.vectorApprox.get(i);
                d = vALPNormDistance.getMinDist((VectorApproximation)object);
                double d3 = vALPNormDistance.getMaxDist((VectorApproximation)object);
                if (d > d2) continue;
                modifiableDoubleDBIDList.add(d, ((VectorApproximation)object).id);
                doubleMaxHeap.add(d3, n);
                if (doubleMaxHeap.size() < n) continue;
                d2 = doubleMaxHeap.peek();
            }
            modifiableDoubleDBIDList.sort();
            KNNHeap kNNHeap = DBIDUtil.newHeap(n);
            object = modifiableDoubleDBIDList.iter();
            while (object.valid()) {
                if (kNNHeap.size() >= n) {
                    d = kNNHeap.getKNNDistance();
                    if (object.doubleValue() > d) break;
                }
                d = this.refine((DBIDRef)object, v);
                kNNHeap.insert(d, (DBIDRef)object);
                object.advance();
            }
            if (LOG.isDebuggingFinest()) {
                LOG.finest("query = (" + v + ")");
                LOG.finest("database: " + VAFile.this.vectorApprox.size() + ", candidates: " + modifiableDoubleDBIDList.size() + ", results: " + kNNHeap.size());
            }
            return kNNHeap.toKNNList();
        }
    }

    public class VAFileRangeQuery
    extends AbstractRefiningIndex.AbstractRangeQuery {
        final double p;

        public VAFileRangeQuery(DistanceQuery<V> distanceQuery, double d) {
            super(distanceQuery);
            this.p = d;
        }

        @Override
        public void getRangeForObject(V v, double d, ModifiableDoubleDBIDList modifiableDoubleDBIDList) {
            VectorApproximation vectorApproximation = VAFile.this.calculateApproximation(null, v);
            VALPNormDistance vALPNormDistance = new VALPNormDistance(this.p, VAFile.this.splitPositions, (NumberVector)v, vectorApproximation);
            ++VAFile.this.scans;
            for (int i = 0; i < VAFile.this.vectorApprox.size(); ++i) {
                double d2;
                VectorApproximation vectorApproximation2 = (VectorApproximation)VAFile.this.vectorApprox.get(i);
                double d3 = vALPNormDistance.getMinDist(vectorApproximation2);
                if (d3 > d || !((d2 = this.refine(vectorApproximation2.id, v)) <= d)) continue;
                modifiableDoubleDBIDList.add(d2, vectorApproximation2.id);
            }
        }
    }
}

