/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math;

import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;

@Reference(authors="B. P. Welford", title="Note on a method for calculating corrected sums of squares and products", booktitle="Technometrics 4(3)")
public class Mean {
    protected double m1 = 0.0;
    protected double n = 0.0;

    public Mean() {
    }

    public Mean(Mean mean) {
        this.m1 = mean.m1;
        this.n = mean.n;
    }

    public void put(double d) {
        this.n += 1.0;
        if (this.m1 == Double.POSITIVE_INFINITY || this.m1 == Double.NEGATIVE_INFINITY) {
            this.m1 += d;
            return;
        }
        double d2 = d - this.m1;
        this.m1 += d2 / this.n;
    }

    public void put(double d, double d2) {
        if (this.m1 == Double.POSITIVE_INFINITY || this.m1 == Double.NEGATIVE_INFINITY) {
            this.m1 += d;
            this.n += 1.0;
            return;
        }
        double d3 = d2 + this.n;
        double d4 = d - this.m1;
        double d5 = d4 * d2 / d3;
        this.m1 += d5;
        this.n = d3;
    }

    public void put(Mean mean) {
        double d = mean.n + this.n;
        this.m1 = (this.n * this.m1 + mean.n * mean.m1) / d;
        this.n = d;
    }

    public Mean put(double[] dArray) {
        for (double d : dArray) {
            this.put(d);
        }
        return this;
    }

    public Mean put(double[] dArray, double[] dArray2) {
        assert (dArray.length == dArray2.length);
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            this.put(dArray[i], dArray2[i]);
        }
        return this;
    }

    public double getCount() {
        return this.n;
    }

    public double getMean() {
        return this.m1;
    }

    public static Mean[] newArray(int n) {
        Mean[] meanArray = new Mean[n];
        for (int i = 0; i < n; ++i) {
            meanArray[i] = new Mean();
        }
        return meanArray;
    }

    public String toString() {
        return "Mean(" + this.getMean() + ")";
    }

    public void reset() {
        this.m1 = 0.0;
        this.n = 0.0;
    }

    public static double of(double[] dArray) {
        double d = 0.0;
        for (double d2 : dArray) {
            d += d2;
        }
        return d / (double)dArray.length;
    }
}

