/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math;

import de.lmu.ifi.dbs.elki.math.Mean;
import de.lmu.ifi.dbs.elki.math.MeanVarianceMinMax;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;

@Reference(authors="T. B. Terriberry", title="Computing Higher-Order Moments Online", booktitle="Online - Technical Note", url="http://people.xiph.org/~tterribe/notes/homs.html")
public class StatisticalMoments
extends MeanVarianceMinMax {
    double m3;
    double m4;

    public StatisticalMoments() {
    }

    public StatisticalMoments(StatisticalMoments statisticalMoments) {
        this.m1 = statisticalMoments.m1;
        this.m2 = statisticalMoments.m2;
        this.n = statisticalMoments.n;
        this.m3 = statisticalMoments.m3;
        this.m4 = statisticalMoments.m4;
    }

    @Override
    public void put(double d) {
        double d2 = this.n + 1.0;
        double d3 = d - this.m1;
        double d4 = d3 / d2;
        double d5 = d4 * d4;
        double d6 = d3 * d4 * this.n;
        this.m4 += d6 * d5 * (d2 * d2 - 3.0 * d2 + 3.0) + 6.0 * d5 * this.m2 - 4.0 * d4 * this.m3;
        this.m3 += d6 * d4 * (d2 - 2.0) - 3.0 * d4 * this.m2;
        this.m2 += d6;
        this.m1 += d4;
        this.n = d2;
        this.min = Math.min(this.min, d);
        this.max = Math.max(this.max, d);
    }

    @Override
    public void put(double d, double d2) {
        double d3 = d2 + this.n;
        double d4 = d - this.m1;
        double d5 = d * d;
        double d6 = d5 * d;
        double d7 = d6 * d;
        double d8 = d4 / d3;
        double d9 = d8 * d8;
        double d10 = d9 * d8;
        double d11 = this.n * this.n;
        double d12 = d2 * d2;
        double d13 = this.n * d2;
        this.m4 += d7 + d4 * d10 * d13 * (d11 - d13 + d12) + 6.0 * (d11 * d5 + d12 * this.m2) * d9 + 4.0 * (this.n * d6 - d2 * this.m3) * d8;
        this.m3 += d6 + d4 * d9 * d13 * (this.n - d2) + 3.0 * (this.n * d5 - d2 * this.m2) * d8;
        this.m2 += d5 + d4 * d8 * this.n * d2;
        this.m1 += d2 * d8;
        this.n = d3;
        this.min = Math.min(this.min, d);
        this.max = Math.max(this.max, d);
    }

    @Override
    public void put(Mean mean) {
        double d;
        StatisticalMoments statisticalMoments;
        if (mean instanceof StatisticalMoments) {
            statisticalMoments = (StatisticalMoments)mean;
            d = statisticalMoments.n + this.n;
            double d2 = statisticalMoments.m1 - this.m1;
            double d3 = d2 / d;
            double d4 = d3 * d3;
            double d5 = d4 * d3;
            double d6 = this.n * this.n;
            double d7 = statisticalMoments.n * statisticalMoments.n;
            double d8 = this.n * statisticalMoments.n;
            this.m4 += statisticalMoments.m4 + d2 * d5 * d8 * (d6 - d8 + d7) + 6.0 * (d6 * statisticalMoments.m2 + d7 * this.m2) * d4 + 4.0 * (this.n * statisticalMoments.m3 - statisticalMoments.n * this.m3) * d3;
            this.m3 += statisticalMoments.m3 + d2 * d4 * d8 * (this.n - statisticalMoments.n) + 3.0 * (this.n * statisticalMoments.m2 - statisticalMoments.n * this.m2) * d3;
            this.m2 += statisticalMoments.m2 + d2 * d3 * this.n * statisticalMoments.n;
            this.m1 += statisticalMoments.n * d3;
        } else {
            throw new AbortException("I cannot combine Mean or MeanVariance into to a StatisticalMoments class.");
        }
        this.n = d;
        this.min = Math.min(this.min, statisticalMoments.min);
        this.max = Math.max(this.max, statisticalMoments.max);
    }

    public double getSampleSkewness() {
        assert (this.n > 2.0) : "Cannot compute a reasonable sample skewness with weight <= 2.0!";
        double d = this.getSampleVariance();
        return this.m3 * this.n / (this.n - 1.0) / (this.n - 2.0) / Math.pow(d, 1.5);
    }

    public double getNaiveSkewness() {
        double d = this.getNaiveVariance();
        return this.m3 / this.n / Math.pow(d, 1.5);
    }

    public double getSampleKurtosis() {
        assert (this.n > 3.0) : "Cannot compute a reasonable sample kurtosis with weight <= 3.0!";
        if (!(this.m2 > 0.0)) {
            throw new ArithmeticException("Kurtosis not defined when variance is 0!");
        }
        double d = this.n - 1.0;
        return d / ((this.n - 2.0) * (this.n - 3.0)) * (this.n * (this.n + 1.0) * this.m4 / (this.m2 * this.m2) - 3.0 * d) + 3.0;
    }

    public double getNaiveKurtosis() {
        if (!(this.m2 > 0.0)) {
            throw new ArithmeticException("Kurtosis not defined when variance is 0!");
        }
        return this.n * this.m4 / (this.m2 * this.m2);
    }

    public double getSampleExcessKurtosis() {
        assert (this.n > 3.0) : "Cannot compute a reasonable sample kurtosis with weight <= 3.0!";
        if (!(this.m2 > 0.0)) {
            throw new ArithmeticException("Kurtosis not defined when variance is 0!");
        }
        double d = this.n - 1.0;
        return d / ((this.n - 2.0) * (this.n - 3.0)) * (this.n * (this.n + 1.0) * this.m4 / (this.m2 * this.m2) - 3.0 * d);
    }

    public double getNaiveExcessKurtosis() {
        if (!(this.m2 > 0.0)) {
            throw new ArithmeticException("Kurtosis not defined when variance is 0!");
        }
        return this.n * this.m4 / (this.m2 * this.m2) - 3.0;
    }

    public static StatisticalMoments[] newArray(int n) {
        StatisticalMoments[] statisticalMomentsArray = new StatisticalMoments[n];
        for (int i = 0; i < n; ++i) {
            statisticalMomentsArray[i] = new StatisticalMoments();
        }
        return statisticalMomentsArray;
    }

    @Override
    public String toString() {
        return "StatisticalMoments(mean=" + this.getMean() + ",m2=" + this.m2 + ",m3=" + this.m3 + ",m4=" + this.m4 + ",n=" + this.n + ")";
    }

    @Override
    public void reset() {
        super.reset();
        this.m3 = 0.0;
        this.m4 = 0.0;
    }
}

