/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.dimensionsimilarity;

import de.lmu.ifi.dbs.elki.algorithm.outlier.meta.HiCS;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.VectorUtil;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.math.dimensionsimilarity.DimensionSimilarity;
import de.lmu.ifi.dbs.elki.math.dimensionsimilarity.DimensionSimilarityMatrix;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.math.statistics.tests.GoodnessOfFitTest;
import de.lmu.ifi.dbs.elki.math.statistics.tests.KolmogorovSmirnovTest;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import java.util.ArrayList;
import java.util.Random;

@Reference(authors="Elke Achtert, Hans-Peter Kriegel, Erich Schubert, Arthur Zimek", title="Interactive Data Mining with 3D-Parallel-Coordinate-Trees", booktitle="Proc. of the 2013 ACM International Conference on Management of Data (SIGMOD)", url="http://dx.doi.org/10.1145/2463676.2463696")
public class HiCSDimensionSimilarity
implements DimensionSimilarity<NumberVector> {
    private int m = 50;
    private double alpha = 0.1;
    private GoodnessOfFitTest statTest;
    private RandomFactory rnd;

    public HiCSDimensionSimilarity(GoodnessOfFitTest goodnessOfFitTest, int n, double d, RandomFactory randomFactory) {
        this.statTest = goodnessOfFitTest;
        this.m = n;
        this.alpha = d;
        this.rnd = randomFactory;
    }

    @Override
    public void computeDimensionSimilarites(Relation<? extends NumberVector> relation, DBIDs dBIDs, DimensionSimilarityMatrix dimensionSimilarityMatrix) {
        Random random = this.rnd.getSingleThreadedRandom();
        int n = dimensionSimilarityMatrix.size();
        ArrayList<ArrayDBIDs> arrayList = this.buildOneDimIndexes(relation, dBIDs, dimensionSimilarityMatrix);
        for (int i = 0; i < n; ++i) {
            int n2 = dimensionSimilarityMatrix.dim(i);
            for (int j = i + 1; j < n; ++j) {
                int n3 = dimensionSimilarityMatrix.dim(j);
                dimensionSimilarityMatrix.set(i, j, this.calculateContrast(relation, dBIDs, arrayList.get(i), arrayList.get(j), n2, n3, random));
            }
        }
    }

    private ArrayList<ArrayDBIDs> buildOneDimIndexes(Relation<? extends NumberVector> relation, DBIDs dBIDs, DimensionSimilarityMatrix dimensionSimilarityMatrix) {
        int n = dimensionSimilarityMatrix.size();
        ArrayList<ArrayDBIDs> arrayList = new ArrayList<ArrayDBIDs>(n);
        VectorUtil.SortDBIDsBySingleDimension sortDBIDsBySingleDimension = new VectorUtil.SortDBIDsBySingleDimension(relation);
        for (int i = 0; i < n; ++i) {
            ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray(dBIDs);
            sortDBIDsBySingleDimension.setDimension(dimensionSimilarityMatrix.dim(i));
            arrayModifiableDBIDs.sort(sortDBIDsBySingleDimension);
            arrayList.add(arrayModifiableDBIDs);
        }
        return arrayList;
    }

    private double calculateContrast(Relation<? extends NumberVector> relation, DBIDs dBIDs, ArrayDBIDs arrayDBIDs, ArrayDBIDs arrayDBIDs2, int n, int n2, Random random) {
        double d = Math.sqrt(this.alpha);
        int n3 = (int)((double)relation.size() * d);
        double d2 = 0.0;
        for (int i = 0; i < this.m; ++i) {
            ArrayDBIDs arrayDBIDs3;
            ArrayDBIDs arrayDBIDs4;
            int n4;
            if (random.nextDouble() > 0.5) {
                n4 = n;
                arrayDBIDs4 = arrayDBIDs;
                arrayDBIDs3 = arrayDBIDs2;
            } else {
                n4 = n2;
                arrayDBIDs4 = arrayDBIDs2;
                arrayDBIDs3 = arrayDBIDs;
            }
            DBIDArrayIter dBIDArrayIter = arrayDBIDs3.iter();
            HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet();
            dBIDArrayIter.seek(random.nextInt(dBIDs.size() - n3));
            for (int j = 0; j < n3 && dBIDArrayIter.valid(); ++j) {
                hashSetModifiableDBIDs.add(dBIDArrayIter);
                dBIDArrayIter.advance();
            }
            double[] dArray = new double[dBIDs.size()];
            double[] dArray2 = new double[hashSetModifiableDBIDs.size()];
            int n5 = 0;
            int n6 = 0;
            DBIDArrayIter dBIDArrayIter2 = arrayDBIDs4.iter();
            while (dBIDArrayIter2.valid()) {
                double d3;
                dArray[n5] = d3 = relation.get(dBIDArrayIter2).doubleValue(n4);
                if (hashSetModifiableDBIDs.contains(dBIDArrayIter2)) {
                    dArray2[n6] = d3;
                    ++n6;
                }
                dBIDArrayIter2.advance();
                ++n5;
            }
            assert (n6 == hashSetModifiableDBIDs.size());
            double d4 = this.statTest.deviation(dArray, dArray2);
            if (Double.isNaN(d4)) {
                --i;
                continue;
            }
            d2 += d4;
        }
        return d2 / (double)this.m;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        private GoodnessOfFitTest statTest;
        private int m = 50;
        private double alpha = 0.1;
        private RandomFactory rnd;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            RandomParameter randomParameter;
            ObjectParameter objectParameter;
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(HiCS.Parameterizer.M_ID, 50);
            intParameter.addConstraint(CommonConstraints.GREATER_THAN_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.m = intParameter.intValue();
            }
            DoubleParameter doubleParameter = new DoubleParameter(HiCS.Parameterizer.ALPHA_ID, 0.1);
            doubleParameter.addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.alpha = doubleParameter.doubleValue();
            }
            if (parameterization.grab(objectParameter = new ObjectParameter(HiCS.Parameterizer.TEST_ID, (Class<?>)GoodnessOfFitTest.class, KolmogorovSmirnovTest.class))) {
                this.statTest = (GoodnessOfFitTest)objectParameter.instantiateClass(parameterization);
            }
            if (parameterization.grab(randomParameter = new RandomParameter(HiCS.Parameterizer.SEED_ID))) {
                this.rnd = (RandomFactory)randomParameter.getValue();
            }
        }

        @Override
        protected HiCSDimensionSimilarity makeInstance() {
            return new HiCSDimensionSimilarity(this.statTest, this.m, this.alpha, this.rnd);
        }
    }
}

