/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.geometry;

import de.lmu.ifi.dbs.elki.data.spatial.Polygon;
import de.lmu.ifi.dbs.elki.math.geometry.SweepHullDelaunay2D;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import java.util.ArrayList;
import java.util.List;

public class AlphaShape {
    private double alpha2;
    private List<Vector> points;
    private ArrayList<SweepHullDelaunay2D.Triangle> delaunay = null;

    public AlphaShape(List<Vector> list, double d) {
        this.alpha2 = d * d;
        this.points = list;
    }

    public List<Polygon> compute() {
        this.delaunay = new SweepHullDelaunay2D(this.points).getDelaunay();
        ArrayList<Polygon> arrayList = new ArrayList<Polygon>();
        long[] lArray = BitsUtil.zero(this.delaunay.size());
        ArrayList<Vector> arrayList2 = new ArrayList<Vector>();
        int n = 0;
        while (n < this.delaunay.size() && n >= 0) {
            if (!BitsUtil.get(lArray, n)) {
                BitsUtil.setI(lArray, n);
                SweepHullDelaunay2D.Triangle triangle = this.delaunay.get(n);
                if (triangle.r2 <= this.alpha2) {
                    this.processNeighbor(arrayList2, lArray, n, triangle.ab, triangle.b);
                    this.processNeighbor(arrayList2, lArray, n, triangle.bc, triangle.c);
                    this.processNeighbor(arrayList2, lArray, n, triangle.ca, triangle.a);
                }
                if (arrayList2.size() > 0) {
                    arrayList.add(new Polygon(arrayList2));
                    arrayList2 = new ArrayList();
                }
            }
            n = BitsUtil.nextClearBit(lArray, n + 1);
        }
        return arrayList;
    }

    private void processNeighbor(List<Vector> list, long[] lArray, int n, int n2, int n3) {
        if (n2 >= 0) {
            if (BitsUtil.get(lArray, n2)) {
                return;
            }
            BitsUtil.setI(lArray, n2);
            SweepHullDelaunay2D.Triangle triangle = this.delaunay.get(n2);
            if (triangle.r2 < this.alpha2) {
                if (triangle.ab == n) {
                    this.processNeighbor(list, lArray, n2, triangle.bc, triangle.c);
                    this.processNeighbor(list, lArray, n2, triangle.ca, triangle.a);
                } else if (triangle.bc == n) {
                    this.processNeighbor(list, lArray, n2, triangle.ca, triangle.a);
                    this.processNeighbor(list, lArray, n2, triangle.ab, triangle.b);
                } else if (triangle.ca == n) {
                    this.processNeighbor(list, lArray, n2, triangle.ab, triangle.b);
                    this.processNeighbor(list, lArray, n2, triangle.bc, triangle.c);
                }
                return;
            }
        }
        list.add(this.points.get(n3));
    }
}

