/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Centroid;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;

public class ProjectedCentroid
extends Centroid {
    private long[] dims;

    public ProjectedCentroid(long[] lArray, int n) {
        super(n);
        this.dims = lArray;
    }

    @Override
    public void put(double[] dArray) {
        assert (dArray.length == this.elements.length);
        this.wsum += 1.0;
        int n = BitsUtil.nextSetBit(this.dims, 0);
        while (n >= 0) {
            double d = dArray[n] - this.elements[n];
            int n2 = n;
            this.elements[n2] = this.elements[n2] + d / this.wsum;
            n = BitsUtil.nextSetBit(this.dims, n + 1);
        }
    }

    @Override
    public void put(double[] dArray, double d) {
        assert (dArray.length == this.elements.length);
        if (d == 0.0) {
            return;
        }
        double d2 = d + this.wsum;
        int n = BitsUtil.nextSetBit(this.dims, 0);
        while (n >= 0) {
            double d3 = dArray[n] - this.elements[n];
            double d4 = d3 * d / d2;
            int n2 = n;
            this.elements[n2] = this.elements[n2] + d4;
            n = BitsUtil.nextSetBit(this.dims, n + 1);
        }
        this.wsum = d2;
    }

    @Override
    public void put(NumberVector numberVector) {
        assert (numberVector.getDimensionality() == this.elements.length);
        this.wsum += 1.0;
        int n = BitsUtil.nextSetBit(this.dims, 0);
        while (n >= 0) {
            double d = numberVector.doubleValue(n) - this.elements[n];
            int n2 = n;
            this.elements[n2] = this.elements[n2] + d / this.wsum;
            n = BitsUtil.nextSetBit(this.dims, n + 1);
        }
    }

    @Override
    public void put(NumberVector numberVector, double d) {
        assert (numberVector.getDimensionality() == this.elements.length);
        if (d == 0.0) {
            return;
        }
        double d2 = d + this.wsum;
        int n = BitsUtil.nextSetBit(this.dims, 0);
        while (n >= 0) {
            double d3 = numberVector.doubleValue(n) - this.elements[n];
            double d4 = d3 * d / d2;
            int n2 = n;
            this.elements[n2] = this.elements[n2] + d4;
            n = BitsUtil.nextSetBit(this.dims, n + 1);
        }
        this.wsum = d2;
    }

    public static ProjectedCentroid make(long[] lArray, Relation<? extends NumberVector> relation) {
        ProjectedCentroid projectedCentroid = new ProjectedCentroid(lArray, RelationUtil.dimensionality(relation));
        DBIDIter dBIDIter = relation.iterDBIDs();
        while (dBIDIter.valid()) {
            projectedCentroid.put(relation.get(dBIDIter));
            dBIDIter.advance();
        }
        return projectedCentroid;
    }

    public static ProjectedCentroid make(long[] lArray, Relation<? extends NumberVector> relation, DBIDs dBIDs) {
        ProjectedCentroid projectedCentroid = new ProjectedCentroid(lArray, RelationUtil.dimensionality(relation));
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            projectedCentroid.put(relation.get(dBIDIter));
            dBIDIter.advance();
        }
        return projectedCentroid;
    }
}

