/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra.pca;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.linearalgebra.EigenPair;
import de.lmu.ifi.dbs.elki.math.linearalgebra.SortedEigenPairs;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.EigenPairFilter;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.FilteredEigenPairs;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import java.util.ArrayList;

@Title(value="Perecentage based Eigenpair filter")
@Description(value="Normalizes all eigenpairs, consisting of eigenvalue e and eigenvector v such that <v,v> * e = 1, where <,> is the standard dot product.")
public class NormalizingEigenPairFilter
implements EigenPairFilter {
    private static final Logging LOG = Logging.getLogger(NormalizingEigenPairFilter.class);

    @Override
    public FilteredEigenPairs filter(SortedEigenPairs sortedEigenPairs) {
        ArrayList<EigenPair> arrayList = new ArrayList<EigenPair>();
        ArrayList<EigenPair> arrayList2 = new ArrayList<EigenPair>();
        for (int i = 0; i < sortedEigenPairs.size(); ++i) {
            EigenPair eigenPair = sortedEigenPairs.getEigenPair(i);
            this.normalizeEigenPair(eigenPair);
            arrayList.add(eigenPair);
        }
        if (LOG.isDebugging()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("strong EigenPairs = ").append(arrayList);
            stringBuilder.append("\nweak EigenPairs = ").append(arrayList2);
            LOG.debugFine(stringBuilder.toString());
        }
        return new FilteredEigenPairs(arrayList2, arrayList);
    }

    private void normalizeEigenPair(EigenPair eigenPair) {
        Vector vector = eigenPair.getEigenvector();
        double d = 1.0 / Math.sqrt(eigenPair.getEigenvalue()) * vector.euclideanLength();
        vector.timesEquals(d);
    }
}

