/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra.pca;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.math.linearalgebra.EigenvalueDecomposition;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.SortedEigenPairs;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.CovarianceMatrixBuilder;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.EigenPairFilter;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.FilteredEigenPairs;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCAFilteredResult;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCARunner;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PercentageEigenPairFilter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.LessGlobalConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

public class PCAFilteredRunner
extends PCARunner {
    private EigenPairFilter eigenPairFilter;
    private double big;
    private double small;

    public PCAFilteredRunner(CovarianceMatrixBuilder covarianceMatrixBuilder, EigenPairFilter eigenPairFilter, double d, double d2) {
        super(covarianceMatrixBuilder);
        this.eigenPairFilter = eigenPairFilter;
        this.big = d;
        this.small = d2;
    }

    @Override
    public PCAFilteredResult processIds(DBIDs dBIDs, Relation<? extends NumberVector> relation) {
        return this.processCovarMatrix(this.covarianceMatrixBuilder.processIds(dBIDs, relation));
    }

    @Override
    public PCAFilteredResult processQueryResult(DoubleDBIDList doubleDBIDList, Relation<? extends NumberVector> relation) {
        return this.processCovarMatrix(this.covarianceMatrixBuilder.processQueryResults(doubleDBIDList, relation));
    }

    @Override
    public PCAFilteredResult processCovarMatrix(Matrix matrix) {
        EigenvalueDecomposition eigenvalueDecomposition = new EigenvalueDecomposition(matrix);
        return this.processEVD(eigenvalueDecomposition);
    }

    @Override
    public PCAFilteredResult processEVD(EigenvalueDecomposition eigenvalueDecomposition) {
        SortedEigenPairs sortedEigenPairs = new SortedEigenPairs(eigenvalueDecomposition, false);
        FilteredEigenPairs filteredEigenPairs = this.eigenPairFilter.filter(sortedEigenPairs);
        return new PCAFilteredResult(sortedEigenPairs, filteredEigenPairs, this.big, this.small);
    }

    protected EigenPairFilter getEigenPairFilter() {
        return this.eigenPairFilter;
    }

    public static class Parameterizer
    extends PCARunner.Parameterizer {
        public static final OptionID PCA_EIGENPAIR_FILTER = new OptionID("pca.filter", "Filter class to determine the strong and weak eigenvectors.");
        public static final OptionID BIG_ID = new OptionID("pca.big", "A constant big value to reset high eigenvalues.");
        public static final OptionID SMALL_ID = new OptionID("pca.small", "A constant small value to reset low eigenvalues.");
        protected EigenPairFilter eigenPairFilter;
        protected double big;
        protected double small;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(PCA_EIGENPAIR_FILTER, (Class<?>)EigenPairFilter.class, PercentageEigenPairFilter.class);
            if (parameterization.grab(objectParameter)) {
                this.eigenPairFilter = (EigenPairFilter)objectParameter.instantiateClass(parameterization);
            }
            DoubleParameter doubleParameter = new DoubleParameter(BIG_ID, 1.0);
            doubleParameter.addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.big = doubleParameter.doubleValue();
            }
            DoubleParameter doubleParameter2 = new DoubleParameter(SMALL_ID, 0.0);
            doubleParameter2.addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE);
            if (parameterization.grab(doubleParameter2)) {
                this.small = doubleParameter2.doubleValue();
            }
            parameterization.checkConstraint(new LessGlobalConstraint<Double>(doubleParameter2, doubleParameter));
        }

        @Override
        protected PCAFilteredRunner makeInstance() {
            return new PCAFilteredRunner(this.covarianceMatrixBuilder, this.eigenPairFilter, this.big, this.small);
        }
    }
}

