/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.Random;

public class GeneralizedParetoDistribution
extends AbstractDistribution {
    final double mu;
    final double sigma;
    final double xi;

    public GeneralizedParetoDistribution(double d, double d2, double d3) {
        this(d, d2, d3, (Random)null);
    }

    public GeneralizedParetoDistribution(double d, double d2, double d3, RandomFactory randomFactory) {
        super(randomFactory);
        this.mu = d;
        this.sigma = d2;
        this.xi = d3;
    }

    public GeneralizedParetoDistribution(double d, double d2, double d3, Random random) {
        super(random);
        this.mu = d;
        this.sigma = d2;
        this.xi = d3;
    }

    public static double pdf(double d, double d2, double d3, double d4) {
        if ((d = (d - d2) / d3) < 0.0 || d4 < 0.0 && d > -1.0 / d4) {
            return 0.0;
        }
        return (d4 == 0.0 ? 1.0 : Math.pow(1.0 + d4 * d, -1.0 / d4 - 1.0)) / d3;
    }

    @Override
    public double pdf(double d) {
        return GeneralizedParetoDistribution.pdf(d, this.mu, this.sigma, this.xi);
    }

    public static double cdf(double d, double d2, double d3, double d4) {
        if ((d = (d - d2) / d3) < 0.0) {
            return 0.0;
        }
        if (d4 < 0.0 && d > -1.0 / d4) {
            return 1.0;
        }
        return 1.0 - Math.pow(1.0 + d4 * d, -1.0 / d4);
    }

    @Override
    public double cdf(double d) {
        return GeneralizedParetoDistribution.cdf(d, this.mu, this.sigma, this.xi);
    }

    public static double quantile(double d, double d2, double d3, double d4) {
        if (d < 0.0 || d > 1.0) {
            return Double.NaN;
        }
        if (d4 == 0.0) {
            return d2 - d3 * Math.log(1.0 - d);
        }
        return d2 - d3 / d4 * (1.0 - Math.pow(1.0 - d, -d4));
    }

    @Override
    public double quantile(double d) {
        return GeneralizedParetoDistribution.quantile(d, this.mu, this.sigma, this.xi);
    }

    @Override
    public String toString() {
        return "GeneralizedParetoDistribution(sigma=" + this.sigma + ", mu=" + this.mu + ", xi=" + this.xi + ")";
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        double mu;
        double sigma;
        double xi;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleParameter doubleParameter;
            DoubleParameter doubleParameter2;
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter3 = new DoubleParameter(LOCATION_ID);
            if (parameterization.grab(doubleParameter3)) {
                this.mu = doubleParameter3.doubleValue();
            }
            if (parameterization.grab(doubleParameter2 = new DoubleParameter(SCALE_ID))) {
                this.sigma = doubleParameter2.doubleValue();
            }
            if (parameterization.grab(doubleParameter = new DoubleParameter(SHAPE_ID))) {
                this.xi = doubleParameter.doubleValue();
            }
        }

        @Override
        protected GeneralizedParetoDistribution makeInstance() {
            return new GeneralizedParetoDistribution(this.mu, this.sigma, this.xi, this.rnd);
        }
    }
}

