/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.Random;

@Alias(value={"GaussianDistribution", "normal", "gauss"})
public class NormalDistribution
extends AbstractDistribution {
    static final double[] ERFAPP_A = new double[]{0.18577770618460315, 3.1611237438705655, 113.86415415105016, 377.485237685302, 3209.3775891384694};
    static final double[] ERFAPP_B = new double[]{1.0, 23.601290952344122, 244.02463793444417, 1282.6165260773723, 2844.236833439171};
    static final double[] ERFAPP_C = new double[]{2.1531153547440383E-8, 0.5641884969886701, 8.883149794388377, 66.11919063714163, 298.6351381974001, 881.952221241769, 1712.0476126340707, 2051.0783778260716, 1230.3393547979972};
    static final double[] ERFAPP_D = new double[]{1.0, 15.744926110709835, 117.6939508913125, 537.1811018620099, 1621.3895745666903, 3290.7992357334597, 4362.619090143247, 3439.3676741437216, 1230.3393548037495};
    static final double[] ERFAPP_P = new double[]{0.016315387137302097, 0.30532663496123236, 0.36034489994980445, 0.12578172611122926, 0.016083785148742275, 6.587491615298378E-4};
    static final double[] ERFAPP_Q = new double[]{1.0, 2.568520192289822, 1.8729528499234604, 0.5279051029514285, 0.06051834131244132, 0.0023352049762686918};
    static final double P_LOW = 0.02425;
    static final double P_HIGH = 0.97575;
    static final double[] ERFINV_A = new double[]{-39.69683028665376, 220.9460984245205, -275.9285104469687, 138.357751867269, -30.66479806614716, 2.506628277459239};
    static final double[] ERFINV_B = new double[]{-54.47609879822406, 161.5858368580409, -155.6989798598866, 66.80131188771972, -13.28068155288572};
    static final double[] ERFINV_C = new double[]{-0.007784894002430293, -0.3223964580411365, -2.400758277161838, -2.549732539343734, 4.374664141464968, 2.938163982698783};
    static final double[] ERFINV_D = new double[]{0.007784695709041462, 0.3224671290700398, 2.445134137142996, 3.754408661907416};
    public static final double PHIINV075 = 0.6744897501960817;
    public static final double ONEBYPHIINV075 = 1.4826022185056018;
    private double mean;
    private double stddev;

    public NormalDistribution(double d, double d2, RandomFactory randomFactory) {
        super(randomFactory);
        this.mean = d;
        this.stddev = d2;
    }

    public NormalDistribution(double d, double d2, Random random) {
        super(random);
        this.mean = d;
        this.stddev = d2;
    }

    public NormalDistribution(double d, double d2) {
        this(d, d2, (Random)null);
    }

    @Override
    public double pdf(double d) {
        return NormalDistribution.pdf(d, this.mean, this.stddev);
    }

    @Override
    public double cdf(double d) {
        return NormalDistribution.cdf(d, this.mean, this.stddev);
    }

    @Override
    public double quantile(double d) {
        return NormalDistribution.quantile(d, this.mean, this.stddev);
    }

    @Override
    public double nextRandom() {
        return this.mean + this.random.nextGaussian() * this.stddev;
    }

    @Override
    public String toString() {
        return "NormalDistribution(mean=" + this.mean + ", stddev=" + this.stddev + ")";
    }

    public double getMean() {
        return this.mean;
    }

    public double getStddev() {
        return this.stddev;
    }

    public static double erfc(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (Double.isInfinite(d)) {
            return d < 0.0 ? 2.0 : 0.0;
        }
        double d2 = Double.NaN;
        double d3 = Math.abs(d);
        if (d3 < 0.46875) {
            double d4 = d * d;
            d2 = 1.0 - d * ((((ERFAPP_A[0] * d4 + ERFAPP_A[1]) * d4 + ERFAPP_A[2]) * d4 + ERFAPP_A[3]) * d4 + ERFAPP_A[4]) / ((((ERFAPP_B[0] * d4 + ERFAPP_B[1]) * d4 + ERFAPP_B[2]) * d4 + ERFAPP_B[3]) * d4 + ERFAPP_B[4]);
        } else if (d3 < 4.0) {
            double d5 = d3;
            d2 = ((((((((ERFAPP_C[0] * d5 + ERFAPP_C[1]) * d5 + ERFAPP_C[2]) * d5 + ERFAPP_C[3]) * d5 + ERFAPP_C[4]) * d5 + ERFAPP_C[5]) * d5 + ERFAPP_C[6]) * d5 + ERFAPP_C[7]) * d5 + ERFAPP_C[8]) / ((((((((ERFAPP_D[0] * d5 + ERFAPP_D[1]) * d5 + ERFAPP_D[2]) * d5 + ERFAPP_D[3]) * d5 + ERFAPP_D[4]) * d5 + ERFAPP_D[5]) * d5 + ERFAPP_D[6]) * d5 + ERFAPP_D[7]) * d5 + ERFAPP_D[8]);
            double d6 = (double)Math.round(d2 * 16.0) / 16.0;
            double d7 = (d3 - d6) * (d3 + d6);
            d2 = Math.exp(-d6 * d6) * Math.exp(-d7) * d2;
            if (d < 0.0) {
                d2 = 2.0 - d2;
            }
        } else {
            double d8 = 1.0 / (d3 * d3);
            d2 = d8 * (((((ERFAPP_P[0] * d8 + ERFAPP_P[1]) * d8 + ERFAPP_P[2]) * d8 + ERFAPP_P[3]) * d8 + ERFAPP_P[4]) * d8 + ERFAPP_P[5]) / (((((ERFAPP_Q[0] * d8 + ERFAPP_Q[1]) * d8 + ERFAPP_Q[2]) * d8 + ERFAPP_Q[3]) * d8 + ERFAPP_Q[4]) * d8 + ERFAPP_Q[5]);
            d2 = (MathUtil.ONE_BY_SQRTPI - d2) / d3;
            double d9 = (double)Math.round(d2 * 16.0) / 16.0;
            double d10 = (d3 - d9) * (d3 + d9);
            d2 = Math.exp(-d9 * d9) * Math.exp(-d10) * d2;
            if (d < 0.0) {
                d2 = 2.0 - d2;
            }
        }
        return d2;
    }

    public static double erf(double d) {
        return 1.0 - NormalDistribution.erfc(d);
    }

    public static double erfinv(double d) {
        return NormalDistribution.standardNormalQuantile(0.5 * (d + 1.0)) * MathUtil.SQRTHALF;
    }

    public static double pdf(double d, double d2, double d3) {
        d = (d - d2) / d3;
        return MathUtil.ONE_BY_SQRTTWOPI / d3 * Math.exp(-0.5 * d * d);
    }

    public static double standardNormalPDF(double d) {
        return Math.exp(-0.5 * d * d) * MathUtil.ONE_BY_SQRTTWOPI;
    }

    public static double cdf(double d, double d2, double d3) {
        d = (d - d2) / d3;
        return 0.5 + 0.5 * NormalDistribution.erf(d * MathUtil.SQRTHALF);
    }

    public static double standardNormalCDF(double d) {
        return 0.5 + 0.5 * NormalDistribution.erf(d * MathUtil.SQRTHALF);
    }

    public static double quantile(double d, double d2, double d3) {
        return d2 + d3 * NormalDistribution.standardNormalQuantile(d);
    }

    public static double standardNormalQuantile(double d) {
        if (d == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (d == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (Double.isNaN(d) || d < 0.0 || d > 1.0) {
            return Double.NaN;
        }
        if (d < 0.02425) {
            double d2 = Math.sqrt(-2.0 * Math.log(d));
            return (((((ERFINV_C[0] * d2 + ERFINV_C[1]) * d2 + ERFINV_C[2]) * d2 + ERFINV_C[3]) * d2 + ERFINV_C[4]) * d2 + ERFINV_C[5]) / ((((ERFINV_D[0] * d2 + ERFINV_D[1]) * d2 + ERFINV_D[2]) * d2 + ERFINV_D[3]) * d2 + 1.0);
        }
        if (0.97575 < d) {
            double d3 = Math.sqrt(-2.0 * Math.log(1.0 - d));
            return -(((((ERFINV_C[0] * d3 + ERFINV_C[1]) * d3 + ERFINV_C[2]) * d3 + ERFINV_C[3]) * d3 + ERFINV_C[4]) * d3 + ERFINV_C[5]) / ((((ERFINV_D[0] * d3 + ERFINV_D[1]) * d3 + ERFINV_D[2]) * d3 + ERFINV_D[3]) * d3 + 1.0);
        }
        double d4 = d - 0.5;
        double d5 = d4 * d4;
        return (((((ERFINV_A[0] * d5 + ERFINV_A[1]) * d5 + ERFINV_A[2]) * d5 + ERFINV_A[3]) * d5 + ERFINV_A[4]) * d5 + ERFINV_A[5]) * d4 / (((((ERFINV_B[0] * d5 + ERFINV_B[1]) * d5 + ERFINV_B[2]) * d5 + ERFINV_B[3]) * d5 + ERFINV_B[4]) * d5 + 1.0);
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        double mu;
        double sigma;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter = new DoubleParameter(LOCATION_ID);
            if (parameterization.grab(doubleParameter)) {
                this.mu = doubleParameter.doubleValue();
            }
            DoubleParameter doubleParameter2 = new DoubleParameter(SCALE_ID);
            doubleParameter2.addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            if (parameterization.grab(doubleParameter2)) {
                this.sigma = doubleParameter2.doubleValue();
            }
        }

        @Override
        protected NormalDistribution makeInstance() {
            return new NormalDistribution(this.mu, this.sigma, this.rnd);
        }
    }
}

