/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.Random;

@Alias(value={"de.lmu.ifi.dbs.elki.data.synthetic.bymodel.distribution.UniformDistribution"})
public class UniformDistribution
extends AbstractDistribution {
    private double min;
    private double max;
    private double len;

    public UniformDistribution(double d, double d2, RandomFactory randomFactory) {
        super(randomFactory);
        if (Double.isInfinite(d) || Double.isInfinite(d2)) {
            throw new ArithmeticException("Infinite values given for uniform distribution.");
        }
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            throw new ArithmeticException("NaN values given for uniform distribution.");
        }
        if (d > d2) {
            double d3 = d;
            d = d2;
            d2 = d3;
        }
        this.min = d;
        this.max = d2;
        this.len = d2 - d;
    }

    public UniformDistribution(double d, double d2, Random random) {
        super(random);
        if (Double.isInfinite(d) || Double.isInfinite(d2)) {
            throw new ArithmeticException("Infinite values given for uniform distribution.");
        }
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            throw new ArithmeticException("NaN values given for uniform distribution.");
        }
        if (d > d2) {
            double d3 = d;
            d = d2;
            d2 = d3;
        }
        this.min = d;
        this.max = d2;
        this.len = d2 - d;
    }

    public UniformDistribution(double d, double d2) {
        this(d, d2, (Random)null);
    }

    @Override
    public double pdf(double d) {
        if (!(d >= this.min) || d >= this.max) {
            return 0.0;
        }
        return this.len > 0.0 ? 1.0 / this.len : Double.POSITIVE_INFINITY;
    }

    @Override
    public double cdf(double d) {
        if (!(d > this.min)) {
            return 0.0;
        }
        if (d >= this.max) {
            return 1.0;
        }
        return this.len > 0.0 ? (d - this.min) / this.len : 0.5;
    }

    @Override
    public double quantile(double d) {
        return this.min + this.len * d;
    }

    @Override
    public double nextRandom() {
        return this.min + this.random.nextDouble() * this.len;
    }

    @Override
    public String toString() {
        return "UniformDistribution(min=" + this.min + ", max=" + this.max + ")";
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        public static final OptionID MIN_ID = new OptionID("distribution.min", "Minimum value of distribution.");
        public static final OptionID MAX_ID = new OptionID("distribution.max", "Maximum value of distribution.");
        double min;
        double max;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleParameter doubleParameter;
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter2 = new DoubleParameter(MIN_ID);
            if (parameterization.grab(doubleParameter2)) {
                this.min = doubleParameter2.doubleValue();
            }
            if (parameterization.grab(doubleParameter = new DoubleParameter(MAX_ID))) {
                this.max = doubleParameter.doubleValue();
            }
        }

        @Override
        protected UniformDistribution makeInstance() {
            return new UniformDistribution(this.min, this.max, this.rnd);
        }
    }
}

