/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.Distribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.AbstractLogMOMEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.LogMADDistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.QuickSelect;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;

public abstract class AbstractLogMADEstimator<D extends Distribution>
implements LogMADDistributionEstimator<D> {
    @Override
    public abstract D estimateFromLogMedianMAD(double var1, double var3, double var5);

    @Override
    public <A> D estimate(A a, NumberArrayAdapter<?, A> numberArrayAdapter) {
        int n = numberArrayAdapter.size(a);
        double d = AbstractLogMOMEstimator.min(a, numberArrayAdapter, 0.0, 1.0E-10);
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            double d2 = numberArrayAdapter.getDouble(a, i) - d;
            double d3 = dArray[i] = d2 > 0.0 ? Math.log(d2) : Double.NEGATIVE_INFINITY;
            if (!Double.isNaN(dArray[i])) continue;
            throw new ArithmeticException("NaN value.");
        }
        double d4 = QuickSelect.median(dArray);
        double d5 = AbstractLogMADEstimator.computeMAD(dArray, d4);
        return this.estimateFromLogMedianMAD(d4, d5, d);
    }

    public static double computeMAD(double[] dArray, double d) {
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Math.abs(dArray[i] - d);
        }
        double d2 = QuickSelect.median(dArray);
        if (!(d2 > 0.0)) {
            double d3 = Double.POSITIVE_INFINITY;
            for (double d4 : dArray) {
                if (!(d4 > 0.0) || !(d4 < d3)) continue;
                d3 = d4;
            }
            d2 = d3 < Double.POSITIVE_INFINITY ? d3 : 1.0;
        }
        return d2;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

