/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.ExponentialDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.AbstractLMMEstimator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="J.R.M. Hosking", title="Fortran routines for use with the method of L-moments Version 3.03", booktitle="IBM Research Technical Report")
public class ExponentialLMMEstimator
extends AbstractLMMEstimator<ExponentialDistribution> {
    public static final ExponentialLMMEstimator STATIC = new ExponentialLMMEstimator();

    private ExponentialLMMEstimator() {
    }

    @Override
    public int getNumMoments() {
        return 2;
    }

    @Override
    public ExponentialDistribution estimateFromLMoments(double[] dArray) {
        double d = 2.0 * dArray[1];
        if (!(d > 0.0)) {
            throw new ArithmeticException("Data with non-positive scale cannot be exponential distributed.");
        }
        return new ExponentialDistribution(1.0 / d, dArray[0] - d);
    }

    @Override
    public Class<? super ExponentialDistribution> getDistributionClass() {
        return ExponentialDistribution.class;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected ExponentialLMMEstimator makeInstance() {
            return STATIC;
        }
    }
}

