/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.GumbelDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.AbstractLMMEstimator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="J.R.M. Hosking", title="Fortran routines for use with the method of L-moments Version 3.03", booktitle="IBM Research Technical Report")
public class GumbelLMMEstimator
extends AbstractLMMEstimator<GumbelDistribution> {
    public static final GumbelLMMEstimator STATIC = new GumbelLMMEstimator();

    private GumbelLMMEstimator() {
    }

    @Override
    public int getNumMoments() {
        return 2;
    }

    @Override
    public GumbelDistribution estimateFromLMoments(double[] dArray) {
        double d = dArray[1] * MathUtil.ONE_BY_LOG2;
        return new GumbelDistribution(dArray[0] - Math.E * d, d);
    }

    @Override
    public Class<? super GumbelDistribution> getDistributionClass() {
        return GumbelDistribution.class;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected GumbelLMMEstimator makeInstance() {
            return STATIC;
        }
    }
}

