/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.result;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHandler;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;

@Description(value="Development result handler that merely logs the structure of the result tree.")
public class LogResultStructureResultHandler
implements ResultHandler {
    private static final Logging LOG = Logging.getLogger(LogResultStructureResultHandler.class);

    @Override
    public void processNewResult(ResultHierarchy resultHierarchy, Result result) {
        if (LOG.isVerbose()) {
            StringBuilder stringBuilder = new StringBuilder();
            this.recursiveLogResult(stringBuilder, resultHierarchy, result, 0);
            LOG.verbose(stringBuilder.toString());
        }
    }

    private void recursiveLogResult(StringBuilder stringBuilder, Hierarchy<Result> hierarchy, Result result, int n) {
        if (result == null) {
            stringBuilder.append("null");
            LOG.warning("null result!");
            return;
        }
        if (n > 50) {
            LOG.warning("Probably infinitely nested results, aborting!");
            return;
        }
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(" ");
        }
        stringBuilder.append(result.getClass().getSimpleName()).append(": ").append(result.getLongName());
        stringBuilder.append(" (").append(result.getShortName()).append(")\n");
        if (hierarchy.numChildren(result) > 0) {
            Hierarchy.Iter<Result> iter = hierarchy.iterChildren(result);
            while (iter.valid()) {
                this.recursiveLogResult(stringBuilder, hierarchy, iter.get(), n + 1);
                iter.advance();
            }
        }
    }
}

