/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.heap;

import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.Iter;
import java.util.Arrays;
import java.util.Comparator;

public class Heap<E> {
    protected Object[] queue;
    protected int size = 0;
    protected final Comparator<Object> comparator;
    private int modCount = 0;
    private static final int DEFAULT_INITIAL_CAPACITY = 11;

    public Heap() {
        this(11, null);
    }

    public Heap(int n) {
        this(n, null);
    }

    public Heap(Comparator<? super E> comparator) {
        this(11, comparator);
    }

    public Heap(int n, Comparator<? super E> comparator) {
        this.queue = new Object[n];
        this.comparator = comparator;
    }

    public void add(E e) {
        if (this.size + 1 > this.queue.length) {
            this.resize(this.size + 1);
        }
        ++this.size;
        this.heapifyUp(this.size - 1, e);
        this.heapModified();
    }

    public E replaceTopElement(E e) {
        Object object = this.queue[0];
        this.heapifyDown(0, e);
        this.heapModified();
        return (E)object;
    }

    public E peek() {
        if (this.size == 0) {
            return null;
        }
        return (E)this.queue[0];
    }

    public E poll() {
        return this.removeAt(0);
    }

    protected E removeAt(int n) {
        if (n < 0 || n >= this.size) {
            return null;
        }
        Object object = this.queue[n];
        Object object2 = this.queue[this.size - 1];
        this.queue[this.size - 1] = null;
        --this.size;
        this.heapifyDown(n, object2);
        this.heapModified();
        return (E)object;
    }

    protected void heapifyUp(int n, E e) {
        assert (n < this.size && n >= 0);
        if (this.comparator != null) {
            this.heapifyUpComparator(n, e);
        } else {
            this.heapifyUpComparable(n, e);
        }
    }

    protected void heapifyUpComparable(int n, Object object) {
        int n2;
        Object object2;
        Comparable comparable = (Comparable)object;
        while (n > 0 && comparable.compareTo(object2 = this.queue[n2 = n - 1 >>> 1]) < 0) {
            this.queue[n] = object2;
            n = n2;
        }
        this.queue[n] = comparable;
    }

    protected void heapifyUpComparator(int n, Object object) {
        int n2;
        Object object2;
        while (n > 0 && this.comparator.compare(object, object2 = this.queue[n2 = n - 1 >>> 1]) < 0) {
            this.queue[n] = object2;
            n = n2;
        }
        this.queue[n] = object;
    }

    protected boolean heapifyDown(int n, Object object) {
        assert (n >= 0);
        if (this.comparator != null) {
            return this.heapifyDownComparator(n, object);
        }
        return this.heapifyDownComparable(n, object);
    }

    protected boolean heapifyDownComparable(int n, Object object) {
        Comparable comparable = (Comparable)object;
        int n2 = n;
        int n3 = this.size >>> 1;
        while (n2 < n3) {
            Object object2;
            int n4 = (n2 << 1) + 1;
            Object object3 = this.queue[n4];
            int n5 = n4 + 1;
            if (n5 < this.size && ((Comparable)object3).compareTo(object2 = this.queue[n5]) > 0) {
                n4 = n5;
                object3 = object2;
            }
            if (comparable.compareTo(object3) <= 0) break;
            this.queue[n2] = object3;
            n2 = n4;
        }
        this.queue[n2] = comparable;
        return n2 != n;
    }

    protected boolean heapifyDownComparator(int n, Object object) {
        int n2 = n;
        int n3 = this.size >>> 1;
        while (n2 < n3) {
            Object object2;
            int n4;
            int n5 = n2;
            Object object3 = object;
            int n6 = (n2 << 1) + 1;
            Object object4 = this.queue[n6];
            if (this.comparator.compare(object3, object4) > 0) {
                n5 = n6;
                object3 = object4;
            }
            if ((n4 = n6 + 1) < this.size && this.comparator.compare(object3, object2 = this.queue[n4]) > 0) {
                n5 = n4;
                object3 = object2;
            }
            if (n5 == n2) break;
            this.queue[n2] = object3;
            n2 = n5;
        }
        this.queue[n2] = object;
        return n2 != n;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    protected final void resize(int n) {
        int n2;
        int n3 = n2 = this.queue.length < 64 ? this.queue.length + 1 << 1 : (this.queue.length >> 1) * 3;
        if (n2 < 0) {
            throw new OutOfMemoryError();
        }
        if (n > n2) {
            n2 = n;
        }
        this.queue = Arrays.copyOf(this.queue, n2);
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.queue[i] = null;
        }
        this.size = 0;
        this.heapModified();
    }

    protected void heapModified() {
        ++this.modCount;
    }

    public UnorderedIter unorderedIter() {
        return new UnorderedIter();
    }

    protected String checkHeap() {
        if (this.comparator == null) {
            for (int i = 1; i < this.size; ++i) {
                int n = i - 1 >>> 1;
                Comparable comparable = (Comparable)this.queue[n];
                if (comparable.compareTo(this.queue[i]) <= 0) continue;
                return "@" + n + ": " + this.queue[n] + " < @" + i + ": " + this.queue[i];
            }
        } else {
            for (int i = 1; i < this.size; ++i) {
                int n = i - 1 >>> 1;
                if (this.comparator.compare(this.queue[n], this.queue[i]) <= 0) continue;
                return "@" + n + ": " + this.queue[n] + " < @" + i + ": " + this.queue[i];
            }
        }
        return null;
    }

    public class UnorderedIter
    implements Iter {
        int pos = 0;

        protected UnorderedIter() {
        }

        @Override
        public boolean valid() {
            return this.pos < Heap.this.size();
        }

        @Override
        public UnorderedIter advance() {
            ++this.pos;
            return this;
        }

        public E get() {
            return Heap.this.queue[this.pos];
        }
    }
}

