/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.heap;

import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.Heap;
import java.util.Comparator;

public class TopBoundedHeap<E>
extends Heap<E> {
    protected int maxsize;

    public TopBoundedHeap(int n) {
        this(n, null);
    }

    public TopBoundedHeap(int n, Comparator<? super E> comparator) {
        super(n + 1, comparator);
        this.maxsize = n;
        assert (n > 0);
    }

    @Override
    public void add(E e) {
        int n;
        Comparable<Object> comparable;
        if (super.size() < this.maxsize) {
            super.add(e);
            return;
        }
        if (this.comparator == null) {
            comparable = (Comparable)e;
            n = comparable.compareTo(this.queue[0]);
        } else {
            n = this.comparator.compare(e, this.queue[0]);
        }
        if (n < 0) {
            return;
        }
        if (n == 0) {
            this.handleOverflow(e);
        } else {
            comparable = super.replaceTopElement(e);
            this.handleOverflow(comparable);
        }
    }

    protected void handleOverflow(E e) {
    }

    public int getMaxSize() {
        return this.maxsize;
    }
}

