/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.histogram;

import de.lmu.ifi.dbs.elki.utilities.datastructures.histogram.AbstractStaticHistogram;
import de.lmu.ifi.dbs.elki.utilities.datastructures.histogram.IntHistogram;
import java.util.Arrays;

public class IntStaticHistogram
extends AbstractStaticHistogram
implements IntHistogram {
    int[] data;

    public IntStaticHistogram(int n, double d, double d2) {
        super(n, d, d2);
        this.data = (int[])(n >= 0 ? new int[n] : null);
    }

    @Override
    public void increment(double d, int n) {
        int n2 = this.getBinNr(d);
        if (n2 < 0) {
            if (this.size - n2 > this.data.length) {
                int[] nArray = new int[IntStaticHistogram.growSize(this.data.length, this.size - n2)];
                System.arraycopy(this.data, 0, nArray, -n2, this.size);
                this.data = nArray;
            } else {
                System.arraycopy(this.data, 0, this.data, -n2, this.size);
                Arrays.fill(this.data, 0, -n2, 0);
            }
            this.data[0] = n;
            assert (this.data.length >= this.size - n2);
            this.offset -= n2;
            this.size -= n2;
        } else if (n2 >= this.data.length) {
            int[] nArray = new int[IntStaticHistogram.growSize(this.data.length, n2 + 1)];
            System.arraycopy(this.data, 0, nArray, 0, this.size);
            nArray[n2] = n;
            this.data = nArray;
            this.size = n2 + 1;
            this.max = Double.MAX_VALUE;
        } else {
            if (n2 >= this.size) {
                this.size = n2 + 1;
            }
            int n3 = n2;
            this.data[n3] = this.data[n3] + n;
        }
    }

    public int get(double d) {
        int n = this.getBinNr(d);
        if (n < 0 || n >= this.size) {
            return 0;
        }
        return this.data[n];
    }

    @Override
    public Iter iter() {
        return new Iter();
    }

    public class Iter
    extends AbstractStaticHistogram.Iter
    implements IntHistogram.Iter {
        @Override
        public int getValue() {
            return IntStaticHistogram.this.data[this.bin];
        }
    }
}

