/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.unionfind;

import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.StaticDBIDs;
import de.lmu.ifi.dbs.elki.utilities.datastructures.unionfind.UnionFind;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import java.util.Arrays;

@Reference(authors="R. Sedgewick", title="1.3 Union-Find Algorithms", booktitle="Algorithms in C, Parts 1-4")
public class WeightedQuickUnionStaticDBIDs
implements UnionFind {
    private ArrayDBIDs ids;
    private WritableIntegerDataStore index;
    private int[] parent;
    private int[] weight;

    WeightedQuickUnionStaticDBIDs(StaticDBIDs staticDBIDs) {
        this.ids = DBIDUtil.ensureArray(staticDBIDs);
        this.index = DataStoreUtil.makeIntegerStorage(staticDBIDs, 3);
        int n = 0;
        DBIDIter dBIDIter = staticDBIDs.iter();
        while (dBIDIter.valid()) {
            this.index.put((DBIDRef)dBIDIter, n++);
            dBIDIter.advance();
        }
        this.weight = new int[staticDBIDs.size()];
        Arrays.fill(this.weight, 1);
        this.parent = new int[staticDBIDs.size()];
        for (int i = 0; i < this.parent.length; ++i) {
            this.parent[i] = i;
        }
    }

    @Override
    public int find(DBIDRef dBIDRef) {
        int n = this.index.intValue(dBIDRef);
        assert (n >= 0 && n < this.ids.size());
        int n2 = this.parent[n];
        while (n != n2) {
            int n3 = n2;
            n2 = this.parent[n] = this.parent[n2];
            n = n3;
        }
        return n;
    }

    @Override
    public int union(DBIDRef dBIDRef, DBIDRef dBIDRef2) {
        int n;
        int n2 = this.find(dBIDRef);
        if (n2 == (n = this.find(dBIDRef2))) {
            return n2;
        }
        int n3 = this.weight[n2];
        int n4 = this.weight[n];
        if (n3 > n4) {
            this.parent[n] = n2;
            int n5 = n2;
            this.weight[n5] = this.weight[n5] + n4;
            return n2;
        }
        this.parent[n2] = n;
        int n6 = n;
        this.weight[n6] = this.weight[n6] + n3;
        return n;
    }

    @Override
    public boolean isConnected(DBIDRef dBIDRef, DBIDRef dBIDRef2) {
        return this.find(dBIDRef) == this.find(dBIDRef2);
    }

    @Override
    public DBIDs getRoots() {
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray();
        DBIDArrayIter dBIDArrayIter = this.ids.iter();
        while (dBIDArrayIter.valid()) {
            if (this.parent[dBIDArrayIter.getOffset()] == dBIDArrayIter.getOffset()) {
                arrayModifiableDBIDs.add(dBIDArrayIter);
            }
            dBIDArrayIter.advance();
        }
        return arrayModifiableDBIDs;
    }
}

