/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.scaling;

import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.scaling.StaticScalingFunction;

public class ClipScaling
implements StaticScalingFunction {
    public static final OptionID MIN_ID = new OptionID("clipscale.min", "Minimum value to allow.");
    public static final OptionID MAX_ID = new OptionID("clipscale.max", "Maximum value to allow.");
    private Double min = null;
    private Double max = null;

    public ClipScaling(Double d, Double d2) {
        this.min = d;
        this.max = d2;
    }

    @Override
    public double getScaled(double d) {
        if (this.min != null && d < this.min) {
            return this.min;
        }
        if (this.max != null && d > this.max) {
            return this.max;
        }
        return d;
    }

    @Override
    public double getMin() {
        return this.min != null ? this.min : Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getMax() {
        return this.max != null ? this.max : Double.POSITIVE_INFINITY;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        protected Double min = null;
        protected Double max = null;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter = new DoubleParameter(MIN_ID);
            doubleParameter.setOptional(true);
            if (parameterization.grab(doubleParameter)) {
                this.min = (Double)doubleParameter.getValue();
            }
            DoubleParameter doubleParameter2 = new DoubleParameter(MAX_ID);
            doubleParameter2.setOptional(true);
            if (parameterization.grab(doubleParameter2)) {
                this.max = (Double)doubleParameter2.getValue();
            }
        }

        @Override
        protected ClipScaling makeInstance() {
            return new ClipScaling(this.min, this.max);
        }
    }
}

