/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.scaling.outlier;

import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierScalingFunction;

@Reference(authors="H.-P. Kriegel, P. Kr\u00f6ger, E. Schubert, A. Zimek", title="Interpreting and Unifying Outlier Scores", booktitle="Proc. 11th SIAM International Conference on Data Mining (SDM), Mesa, AZ, 2011", url="http://dx.doi.org/10.1137/1.9781611972818.2")
public class OutlierMinusLogScaling
implements OutlierScalingFunction {
    double max = 0.0;
    double mlogmax;

    @Override
    public double getScaled(double d) {
        assert (this.max != 0.0) : "prepare() was not run prior to using the scaling function.";
        return -Math.log(d / this.max) / this.mlogmax;
    }

    @Override
    public double getMin() {
        return 0.0;
    }

    @Override
    public double getMax() {
        return 1.0;
    }

    @Override
    public void prepare(OutlierResult outlierResult) {
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        DoubleRelation doubleRelation = outlierResult.getScores();
        DBIDIter dBIDIter = doubleRelation.iterDBIDs();
        while (dBIDIter.valid()) {
            double d = doubleRelation.doubleValue(dBIDIter);
            if (!Double.isNaN(d) && !Double.isInfinite(d)) {
                doubleMinMax.put(d);
            }
            dBIDIter.advance();
        }
        this.max = doubleMinMax.getMax();
        this.mlogmax = -Math.log(doubleMinMax.getMin() / this.max);
    }

    @Override
    public <A> void prepare(A a, NumberArrayAdapter<?, A> numberArrayAdapter) {
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        int n = numberArrayAdapter.size(a);
        for (int i = 0; i < n; ++i) {
            double d = numberArrayAdapter.getDouble(a, i);
            if (Double.isNaN(d) || Double.isInfinite(d)) continue;
            doubleMinMax.put(d);
        }
        this.max = doubleMinMax.getMax();
        this.mlogmax = -Math.log(doubleMinMax.getMin() / this.max);
    }
}

