/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.css;

import de.lmu.ifi.dbs.elki.utilities.pairs.Pair;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class CSSClass {
    private String name;
    private Collection<Pair<String, String>> statements;
    private WeakReference<Object> owner;

    public CSSClass(Object object, String string, Collection<Pair<String, String>> collection) {
        this.owner = new WeakReference<Object>(object);
        this.name = string;
        this.statements = collection;
        if (!CSSClass.checkName(string)) {
            throw new InvalidCSS("Given name is not a valid CSS class name.");
        }
        if (this.statements != null) {
            if (!CSSClass.checkCSSStatements(this.statements)) {
                throw new InvalidCSS("Invalid statement in CSS class " + string);
            }
        } else {
            this.statements = new ArrayList<Pair<String, String>>();
        }
    }

    public CSSClass(Object object, String string) {
        this(object, string, (Collection<Pair<String, String>>)null);
    }

    public CSSClass(Object object, String string, CSSClass cSSClass) {
        this(object, string, new ArrayList<Pair<String, String>>(cSSClass.statements));
    }

    public static boolean checkName(String string) {
        return string != null;
    }

    public static String sanitizeName(String string) {
        return string;
    }

    public static boolean checkCSSStatement(String string, String string2) {
        return string != null && string2 != null;
    }

    public static boolean checkCSSStatements(Collection<Pair<String, String>> collection) {
        for (Pair<String, String> pair : collection) {
            if (CSSClass.checkCSSStatement(pair.getFirst(), pair.getSecond())) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Object getOwner() {
        return this.owner.get();
    }

    public String getStatement(String string) {
        for (Pair<String, String> pair : this.statements) {
            if (!pair.getFirst().equals(string)) continue;
            return pair.getSecond();
        }
        return null;
    }

    public Collection<Pair<String, String>> getStatements() {
        return Collections.unmodifiableCollection(this.statements);
    }

    public void setStatement(String string, String string2) {
        if (string2 != null && !CSSClass.checkCSSStatement(string, string2)) {
            throw new InvalidCSS("Invalid CSS statement.");
        }
        for (Pair<String, String> pair : this.statements) {
            if (!pair.getFirst().equals(string)) continue;
            if (string2 != null) {
                pair.setSecond(string2);
            } else {
                this.statements.remove(pair);
            }
            return;
        }
        if (string2 != null) {
            this.statements.add(new Pair<String, String>(string, string2));
        }
    }

    public void setStatement(String string, int n) {
        this.setStatement(string, Integer.toString(n));
    }

    public void setStatement(String string, double d) {
        this.setStatement(string, Double.toString(d));
    }

    public void removeStatement(String string) {
        this.setStatement(string, null);
    }

    public void appendCSSDefinition(StringBuilder stringBuilder) {
        stringBuilder.append("\n.");
        stringBuilder.append(this.name);
        stringBuilder.append('{');
        for (Pair<String, String> pair : this.statements) {
            stringBuilder.append(pair.getFirst());
            stringBuilder.append(':');
            stringBuilder.append(pair.getSecond());
            stringBuilder.append(";\n");
        }
        stringBuilder.append("}\n");
    }

    public String inlineCSS() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Pair<String, String> pair : this.statements) {
            stringBuilder.append(pair.getFirst());
            stringBuilder.append(':');
            stringBuilder.append(pair.getSecond());
            stringBuilder.append(';');
        }
        return stringBuilder.toString();
    }

    public class InvalidCSS
    extends RuntimeException {
        private static final long serialVersionUID = 3130536799704124363L;

        public InvalidCSS(String string) {
            super(string);
        }
    }
}

