/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.gui;

import de.lmu.ifi.dbs.elki.KDDTask;
import de.lmu.ifi.dbs.elki.data.ClassLabel;
import de.lmu.ifi.dbs.elki.data.SimpleClassLabel;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.UpdatableDatabase;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreEvent;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreListener;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.ModifiableRelation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.DBIDSelection;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultListener;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.SelectionResult;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class SelectionTableWindow
extends JFrame
implements DataStoreListener,
ResultListener {
    private static final String NAME = "Selected data objects";
    private static final long serialVersionUID = 1L;
    private JTable table;
    private JButton closeButton;
    private JButton deleteButton;
    private DatabaseTableModel dotTableModel = new DatabaseTableModel();
    private static final Logging LOG = Logging.getLogger(SelectionTableWindow.class);
    ArrayModifiableDBIDs dbids;
    UpdatableDatabase database;
    ModifiableRelation<ClassLabel> crep;
    ModifiableRelation<String> orep;
    protected final VisualizerContext context;

    public SelectionTableWindow(VisualizerContext visualizerContext) {
        super(NAME);
        try {
            this.setIconImage(new ImageIcon(KDDTask.class.getResource("elki-icon.png")).getImage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.context = visualizerContext;
        this.database = (UpdatableDatabase)ResultUtil.findDatabase(visualizerContext.getHierarchy());
        this.crep = null;
        this.orep = null;
        this.updateFromSelection();
        JPanel jPanel = new JPanel(new BorderLayout());
        this.table = new JTable(this.dotTableModel);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel.add((Component)jPanel2, "South");
        this.closeButton = new JButton("close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectionTableWindow.this.dispose();
            }
        });
        this.deleteButton = new JButton("delete");
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectionTableWindow.this.handleDelete();
            }
        });
        jPanel2.add(this.closeButton);
        jPanel2.add(this.deleteButton);
        this.setSize(500, 500);
        this.add(jPanel);
        this.setVisible(true);
        this.setResizable(true);
        this.setDefaultCloseOperation(2);
        visualizerContext.addResultListener(this);
        visualizerContext.addDataStoreListener(this);
    }

    @Override
    public void dispose() {
        this.context.removeDataStoreListener(this);
        this.context.removeResultListener(this);
        super.dispose();
    }

    protected void updateFromSelection() {
        DBIDSelection dBIDSelection = this.context.getSelection();
        if (dBIDSelection != null) {
            this.dbids = DBIDUtil.newArray(dBIDSelection.getSelectedIds());
            this.dbids.sort();
        } else {
            this.dbids = DBIDUtil.newArray();
        }
    }

    protected void handleDelete() {
        HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet();
        HashSetModifiableDBIDs hashSetModifiableDBIDs2 = DBIDUtil.newHashSet(this.dbids);
        DBIDArrayMIter dBIDArrayMIter = this.dbids.iter();
        for (int n : this.table.getSelectedRows()) {
            dBIDArrayMIter.seek(n);
            hashSetModifiableDBIDs.add(dBIDArrayMIter);
            hashSetModifiableDBIDs2.remove(dBIDArrayMIter);
        }
        this.context.setSelection(new DBIDSelection(hashSetModifiableDBIDs2));
        Object object = hashSetModifiableDBIDs.iter();
        while (object.valid()) {
            this.database.delete((DBIDRef)object);
            object.advance();
        }
    }

    @Override
    public void contentChanged(DataStoreEvent dataStoreEvent) {
        if (dataStoreEvent.getInserts().isEmpty() && dataStoreEvent.getRemovals().isEmpty() && !dataStoreEvent.getUpdates().isEmpty()) {
            this.dotTableModel.fireTableDataChanged();
        } else {
            this.dotTableModel.fireTableStructureChanged();
        }
    }

    @Override
    public void resultAdded(Result result, Result result2) {
    }

    @Override
    public void resultRemoved(Result result, Result result2) {
    }

    @Override
    public void resultChanged(Result result) {
        if (result instanceof SelectionResult || result instanceof Database) {
            this.updateFromSelection();
            this.dotTableModel.fireTableStructureChanged();
        }
    }

    class DatabaseTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        DatabaseTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return SelectionTableWindow.this.dbids.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DBIDArrayIter dBIDArrayIter = SelectionTableWindow.this.dbids.iter().seek(n);
            if (n2 == 0) {
                return DBIDUtil.toString(dBIDArrayIter);
            }
            if (n2 == 1) {
                return SelectionTableWindow.this.orep.get(dBIDArrayIter);
            }
            if (n2 == 2) {
                return SelectionTableWindow.this.crep.get(dBIDArrayIter);
            }
            return null;
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return "DBID";
            }
            if (n == 1) {
                return "Object label";
            }
            if (n == 2) {
                return "Class label";
            }
            return "Dim " + (n - 3 + 1);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 != 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                LOG.warning("Tried to edit DBID, this is not allowed.");
                return;
            }
            DBIDArrayIter dBIDArrayIter = SelectionTableWindow.this.dbids.iter().seek(n);
            if (n2 == 1 && object instanceof String) {
                SelectionTableWindow.this.orep.insert(dBIDArrayIter, (String)object);
            }
            if (n2 == 2 && object instanceof String) {
                SimpleClassLabel simpleClassLabel = new SimpleClassLabel((String)object);
                SelectionTableWindow.this.crep.insert(dBIDArrayIter, simpleClassLabel);
            }
            if (!(object instanceof String)) {
                LOG.warning("Was expecting a String value from the input element, got: " + object.getClass());
                return;
            }
            throw new AbortException("FIXME: INCOMPLETE TRANSITION");
        }
    }
}

