/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.projections;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.linearalgebra.AffineTransformation;
import de.lmu.ifi.dbs.elki.math.scales.LinearScale;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.visualization.projections.AbstractFullProjection;
import de.lmu.ifi.dbs.elki.visualization.projections.CanvasSize;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection2D;
import de.lmu.ifi.dbs.elki.visualization.projector.Projector;
import java.util.Arrays;

public class AffineProjection
extends AbstractFullProjection
implements Projection2D {
    private AffineTransformation proj;
    private CanvasSize viewport = null;

    public AffineProjection(Projector projector, LinearScale[] linearScaleArray, AffineTransformation affineTransformation) {
        super(projector, linearScaleArray);
        this.proj = affineTransformation;
    }

    @Override
    public double[] projectScaledToRender(double[] dArray) {
        return this.proj.apply(dArray);
    }

    @Override
    public double[] projectRenderToScaled(double[] dArray) {
        return this.proj.applyInverse(dArray);
    }

    @Override
    public double[] projectRelativeScaledToRender(double[] dArray) {
        return this.proj.applyRelative(dArray);
    }

    @Override
    public double[] projectRelativeRenderToScaled(double[] dArray) {
        return this.proj.applyRelativeInverse(dArray);
    }

    @Override
    public CanvasSize estimateViewport() {
        if (this.viewport == null) {
            int n = this.proj.getDimensionality();
            DoubleMinMax doubleMinMax = new DoubleMinMax();
            DoubleMinMax doubleMinMax2 = new DoubleMinMax();
            double[] dArray = new double[n];
            double[] dArray2 = this.projectScaledToRender(dArray);
            doubleMinMax.put(dArray2[0]);
            doubleMinMax2.put(dArray2[1]);
            Arrays.fill(dArray, 1.0);
            double[] dArray3 = this.projectScaledToRender(dArray);
            doubleMinMax.put(dArray3[0]);
            doubleMinMax2.put(dArray3[1]);
            for (int i = 0; i < n; ++i) {
                Arrays.fill(dArray, 0.0);
                dArray[i] = 1.0;
                double[] dArray4 = this.projectScaledToRender(dArray);
                doubleMinMax.put(dArray4[0]);
                doubleMinMax2.put(dArray4[1]);
            }
            this.viewport = new CanvasSize(doubleMinMax.getMin(), doubleMinMax.getMax(), doubleMinMax2.getMin(), doubleMinMax2.getMax());
        }
        return this.viewport;
    }

    public static AffineTransformation axisProjection(int n, int n2, int n3) {
        AffineTransformation affineTransformation = AffineTransformation.reorderAxesTransformation(n, new int[]{n2, n3});
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = -0.5;
        }
        affineTransformation.addTranslation(dArray);
        affineTransformation.addAxisReflection(2);
        affineTransformation.addScaling(100.0);
        return affineTransformation;
    }

    @Override
    public double[] fastProjectDataToRenderSpace(double[] dArray) {
        return this.fastProjectScaledToRenderSpace(this.fastProjectDataToScaledSpace(dArray));
    }

    @Override
    public double[] fastProjectDataToRenderSpace(NumberVector numberVector) {
        return this.fastProjectScaledToRenderSpace(this.fastProjectDataToScaledSpace(numberVector));
    }

    @Override
    public double[] fastProjectDataToScaledSpace(double[] dArray) {
        return this.projectDataToScaledSpace(dArray);
    }

    @Override
    public double[] fastProjectDataToScaledSpace(NumberVector numberVector) {
        return this.projectDataToScaledSpace(numberVector);
    }

    @Override
    public double[] fastProjectScaledToRenderSpace(double[] dArray) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double[][] dArray2 = this.proj.getTransformation().getArrayRef();
        double[] dArray3 = dArray2[0];
        double[] dArray4 = dArray2[1];
        double[] dArray5 = dArray2[dArray.length];
        assert (dArray3.length == dArray4.length && dArray3.length == dArray5.length && dArray5.length == dArray.length + 1);
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray3[i] * dArray[i];
            d2 += dArray4[i] * dArray[i];
            d3 += dArray5[i] * dArray[i];
        }
        return new double[]{(d += dArray3[dArray.length]) / (d3 += dArray5[dArray.length]), (d2 += dArray4[dArray.length]) / d3};
    }

    @Override
    public double[] fastProjectRelativeDataToRenderSpace(double[] dArray) {
        return this.fastProjectRelativeScaledToRenderSpace(this.projectRelativeDataToScaledSpace(dArray));
    }

    @Override
    public double[] fastProjectRelativeDataToRenderSpace(NumberVector numberVector) {
        return this.fastProjectRelativeScaledToRenderSpace(this.projectRelativeDataToScaledSpace(numberVector));
    }

    @Override
    public double[] fastProjectRelativeScaledToRenderSpace(double[] dArray) {
        double d = 0.0;
        double d2 = 0.0;
        double[][] dArray2 = this.proj.getTransformation().getArrayRef();
        double[] dArray3 = dArray2[0];
        double[] dArray4 = dArray2[1];
        assert (dArray3.length == dArray4.length);
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray3[i] * dArray[i];
            d2 += dArray4[i] * dArray[i];
        }
        return new double[]{d, d2};
    }

    @Override
    public double[] fastProjectRenderToDataSpace(double d, double d2) {
        double[] dArray = this.fastProjectRenderToScaledSpace(d, d2);
        for (int i = 0; i < this.scales.length; ++i) {
            dArray[i] = this.scales[i].getUnscaled(dArray[i]);
        }
        return dArray;
    }

    @Override
    public double[] fastProjectRenderToScaledSpace(double d, double d2) {
        double[] dArray = new double[this.scales.length];
        dArray[0] = d;
        dArray[1] = d2;
        Arrays.fill(dArray, 2, this.scales.length, 0.5);
        return this.projectRenderToScaled(dArray);
    }

    @Override
    public long[] getVisibleDimensions2D() {
        int n = this.proj.getDimensionality();
        long[] lArray = BitsUtil.zero(n);
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            Arrays.fill(dArray, 0.0);
            dArray[i] = 1.0;
            double[] dArray2 = this.fastProjectScaledToRenderSpace(dArray);
            if (!(dArray2[0] > 0.0) && !(dArray2[0] < 0.0) && dArray2[1] == 0.0) continue;
            BitsUtil.setI(lArray, i);
        }
        return lArray;
    }
}

