/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.projector;

import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.ScalesResult;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.gui.overview.PlotItem;
import de.lmu.ifi.dbs.elki.visualization.projections.SimpleParallel;
import de.lmu.ifi.dbs.elki.visualization.projector.Projector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ParallelPlotProjector<V extends SpatialComparable>
implements Projector {
    Relation<V> rel;

    public ParallelPlotProjector(Relation<V> relation) {
        this.rel = relation;
    }

    @Override
    public Collection<PlotItem> arrange(VisualizerContext visualizerContext) {
        ArrayList<PlotItem> arrayList = new ArrayList<PlotItem>(1);
        List<VisualizationTask> list = visualizerContext.getVisTasks(this);
        if (list.size() > 0) {
            ScalesResult scalesResult = ResultUtil.getScalesResult(this.rel);
            SimpleParallel simpleParallel = new SimpleParallel(this, scalesResult.getScales());
            double d = Math.max(0.5, Math.ceil(MathUtil.log2(scalesResult.getScales().length - 1)));
            PlotItem plotItem = new PlotItem(d, 1.0, simpleParallel);
            plotItem.tasks = list;
            arrayList.add(plotItem);
        }
        return arrayList;
    }

    @Override
    public String getMenuName() {
        return "Parallelplot";
    }

    public Relation<V> getRelation() {
        return this.rel;
    }
}

