/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.projector;

import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.FilteredIter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.projector.ProjectorFactory;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;

public class ScatterPlotFactory
implements ProjectorFactory {
    public static final int MAX_DIMENSIONS_DEFAULT = 10;
    private int maxdim = 10;

    public ScatterPlotFactory(int n) {
        this.maxdim = n;
    }

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        Hierarchy.Iter<Relation> iter = VisualizationTree.filterResults(visualizerContext, object, Relation.class);
        while (iter.valid()) {
            block4: {
                Relation relation = iter.get();
                int n = this.dimensionality(relation);
                if (n >= 1) {
                    Relation relation2;
                    FilteredIter<Relation> filteredIter = new FilteredIter<Relation>(visualizerContext.getHierarchy().iterAncestors(relation), Relation.class);
                    while (filteredIter.valid()) {
                        relation2 = (Relation)filteredIter.get();
                        int n2 = this.dimensionality(relation2);
                        if (n2 != n) {
                            filteredIter.advance();
                            continue;
                        }
                        break block4;
                    }
                    relation2 = relation;
                    ScatterPlotProjector scatterPlotProjector = new ScatterPlotProjector(relation2, Math.min(this.maxdim, n));
                    visualizerContext.addVis(relation2, scatterPlotProjector);
                }
            }
            iter.advance();
        }
    }

    private int dimensionality(Relation<?> relation) {
        if (TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(relation.getDataTypeInformation())) {
            Relation<?> relation2 = relation;
            return RelationUtil.dimensionality(relation2);
        }
        if (TypeUtil.UNCERTAIN_OBJECT_FIELD.isAssignableFromType(relation.getDataTypeInformation())) {
            Relation<?> relation3 = relation;
            return RelationUtil.dimensionality(relation3);
        }
        return 0;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID MAXDIM_ID = new OptionID("vis.maxdim", "Maximum number of dimensions to display.");
        private int maxdim = 10;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(MAXDIM_ID, 10);
            intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_INT);
            if (parameterization.grab(intParameter)) {
                this.maxdim = intParameter.intValue();
            }
        }

        @Override
        protected ScatterPlotFactory makeInstance() {
            return new ScatterPlotFactory(this.maxdim);
        }
    }
}

