/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.savedialog;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.FileUtil;
import de.lmu.ifi.dbs.elki.visualization.batikutil.BatikUtil;
import de.lmu.ifi.dbs.elki.visualization.savedialog.SaveOptionsPanel;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.apache.batik.ext.awt.image.spi.ImageTagRegistry;
import org.apache.batik.ext.awt.image.spi.ImageWriterRegistry;
import org.apache.batik.transcoder.TranscoderException;

public class SVGSaveDialog {
    public static final String DEFAULT_TITLE = "Save as ...";
    private static final Logging LOG = Logging.getLogger(SVGSaveDialog.class);
    static final String AUTOMAGIC_FORMAT = "automatic";
    static final String[] FORMATS;
    static final String[] VISIBLE_FORMATS;

    public static int showSaveDialog(SVGPlot sVGPlot, int n, int n2) {
        int n3;
        block21: {
            double d = 1.0;
            n3 = -1;
            JFileChooser jFileChooser = new JFileChooser(new File("."));
            jFileChooser.setDialogTitle(DEFAULT_TITLE);
            SaveOptionsPanel saveOptionsPanel = new SaveOptionsPanel(jFileChooser, n, n2);
            jFileChooser.setAccessory(saveOptionsPanel);
            n3 = jFileChooser.showSaveDialog(null);
            jFileChooser.setDialogTitle("Saving... Please wait.");
            if (n3 == 0) {
                File file = jFileChooser.getSelectedFile();
                String string = saveOptionsPanel.getSelectedFormat();
                if (string == null || AUTOMAGIC_FORMAT.equals(string)) {
                    string = SVGSaveDialog.guessFormat(file.getName());
                }
                try {
                    if (string == null) {
                        SVGSaveDialog.showError(jFileChooser, "Error saving image.", "File format not recognized.");
                        break block21;
                    }
                    if ("jpeg".equals(string) || "jpg".equals(string)) {
                        d = saveOptionsPanel.getJPEGQuality();
                        sVGPlot.saveAsJPEG(file, n, n2, d);
                        break block21;
                    }
                    if ("png".equals(string)) {
                        sVGPlot.saveAsPNG(file, n, n2);
                        break block21;
                    }
                    if ("ps".equals(string)) {
                        sVGPlot.saveAsPS(file);
                        break block21;
                    }
                    if ("eps".equals(string)) {
                        sVGPlot.saveAsEPS(file);
                        break block21;
                    }
                    if ("pdf".equals(string)) {
                        sVGPlot.saveAsPDF(file);
                        break block21;
                    }
                    if ("svg".equals(string)) {
                        sVGPlot.saveAsSVG(file);
                        break block21;
                    }
                    SVGSaveDialog.showError(jFileChooser, "Error saving image.", "Unsupported format: " + string);
                }
                catch (IncompatibleClassChangeError incompatibleClassChangeError) {
                    SVGSaveDialog.showError(jFileChooser, "Error saving image.", "It seems that your Java version is incompatible with this version of Batik and Jpeg writing. Sorry.");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    SVGSaveDialog.showError(jFileChooser, "Error saving image.", "A class was not found when saving this image. Maybe installing Apache FOP will help (for PDF, PS and EPS output).\n" + classNotFoundException.toString());
                }
                catch (IOException iOException) {
                    LOG.exception(iOException);
                    SVGSaveDialog.showError(jFileChooser, "Error saving image.", iOException.toString());
                }
                catch (TranscoderException transcoderException) {
                    LOG.exception(transcoderException);
                    SVGSaveDialog.showError(jFileChooser, "Error saving image.", transcoderException.toString());
                }
                catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
                    LOG.exception(transformerFactoryConfigurationError);
                    SVGSaveDialog.showError(jFileChooser, "Error saving image.", transformerFactoryConfigurationError.toString());
                }
                catch (TransformerException transformerException) {
                    LOG.exception(transformerException);
                    SVGSaveDialog.showError(jFileChooser, "Error saving image.", transformerException.toString());
                }
                catch (Exception exception) {
                    LOG.exception(exception);
                    SVGSaveDialog.showError(jFileChooser, "Error saving image.", exception.toString());
                }
            } else if (n3 == -1) {
                SVGSaveDialog.showError(jFileChooser, "Error in file dialog.", "Unknown Error.");
            } else if (n3 == 1) {
                // empty if block
            }
        }
        return n3;
    }

    public static String guessFormat(String string) {
        String string2 = FileUtil.getFilenameExtension(string);
        for (String string3 : FORMATS) {
            if (!string3.equals(string2)) continue;
            return string2;
        }
        return null;
    }

    public static String[] getFormats() {
        return FORMATS;
    }

    public static String[] getVisibleFormats() {
        return VISIBLE_FORMATS;
    }

    private static void showError(Component component, String string, String string2) {
        JOptionPane.showMessageDialog(component, string2, string, 0);
    }

    static {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(AUTOMAGIC_FORMAT);
        arrayList.add("svg");
        ImageWriterRegistry imageWriterRegistry = ImageWriterRegistry.getInstance();
        ImageTagRegistry imageTagRegistry = ImageTagRegistry.getRegistry();
        if (imageTagRegistry.getRegisteredMimeTypes().contains("image/png")) {
            if (imageWriterRegistry.getWriterFor("image/png") != null) {
                arrayList.add("png");
            }
            if (imageWriterRegistry.getWriterFor("image/jpeg") != null) {
                arrayList.add("jpeg");
            }
        }
        if (BatikUtil.hasFOPInstalled()) {
            arrayList.add("pdf");
            arrayList.add("ps");
            arrayList.add("eps");
        }
        FORMATS = arrayList.toArray(new String[arrayList.size()]);
        arrayList.remove(0);
        VISIBLE_FORMATS = arrayList.toArray(new String[arrayList.size()]);
    }
}

