/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.style;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.FileUtil;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.visualization.colors.ColorLibrary;
import de.lmu.ifi.dbs.elki.visualization.colors.ListBasedColorLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.lines.LineStyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.lines.SolidLineStyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.marker.MarkerLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.marker.PrettyMarkers;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class PropertiesBasedStyleLibrary
implements StyleLibrary {
    private static final Logging LOG = Logging.getLogger(PropertiesBasedStyleLibrary.class);
    public static final String DEFAULT_SCHEME_NAME = "Default";
    public static final String DEFAULT_SCHEME_FILENAME = "default";
    public static final String DEFAULT_PROPERTIES_EXTENSION = ".properties";
    private static final String DEFAULT_PROPERTIES_PATH = PropertiesBasedStyleLibrary.class.getPackage().getName().replace('.', File.separatorChar) + File.separatorChar;
    public static final String LIST_SEPARATOR = ",";
    public static final String PROP_LINES_LIBRARY = "lines-library";
    public static final String PROP_MARKER_LIBRARY = "marker-library";
    private Properties properties;
    private String name;
    private Map<String, Object> cache = new HashMap<String, Object>();
    private LineStyleLibrary linelib = null;
    private MarkerLibrary markerlib = null;

    public PropertiesBasedStyleLibrary() {
        this(DEFAULT_SCHEME_FILENAME, DEFAULT_SCHEME_NAME);
    }

    public PropertiesBasedStyleLibrary(String string, String string2) {
        this.properties = new Properties();
        this.name = string2;
        InputStream inputStream = null;
        try {
            inputStream = FileUtil.openSystemFile(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                inputStream = FileUtil.openSystemFile(string + DEFAULT_PROPERTIES_EXTENSION);
            }
            catch (FileNotFoundException fileNotFoundException2) {
                try {
                    inputStream = FileUtil.openSystemFile(DEFAULT_PROPERTIES_PATH + string + DEFAULT_PROPERTIES_EXTENSION);
                }
                catch (FileNotFoundException fileNotFoundException3) {
                    throw new AbortException("Could not find style scheme file '" + string + "' for scheme '" + string2 + "'!");
                }
            }
        }
        try {
            this.properties.load(inputStream);
        }
        catch (Exception exception) {
            throw new AbortException("Error loading properties file " + string + ".\n", exception);
        }
    }

    protected String getName() {
        return this.name;
    }

    private <T> T getCached(String string, String string2, Class<T> clazz) {
        return clazz.cast(this.cache.get(string + '.' + string2));
    }

    private <T> void setCached(String string, String string2, T t) {
        this.cache.put(string + '.' + string2, t);
    }

    protected String getPropertyValue(String string, String string2) {
        String string3 = this.properties.getProperty(string + "." + string2);
        if (string3 != null) {
            return string3;
        }
        int n = string.length();
        while (n > 0 && (n = string.lastIndexOf(46, n - 1)) > 0) {
            string3 = this.properties.getProperty(string.substring(0, n) + '.' + string2);
            if (string3 == null) continue;
            return string3;
        }
        string3 = this.properties.getProperty(string2);
        if (string3 != null) {
            return string3;
        }
        return null;
    }

    @Override
    public String getColor(String string) {
        return this.getPropertyValue(string, "color");
    }

    @Override
    public String getBackgroundColor(String string) {
        return this.getPropertyValue(string, "background-color");
    }

    @Override
    public String getTextColor(String string) {
        return this.getPropertyValue(string, "text-color");
    }

    @Override
    public ColorLibrary getColorSet(String string) {
        ColorLibrary colorLibrary = this.getCached(string, "colorset", ColorLibrary.class);
        if (colorLibrary == null) {
            String[] stringArray = this.getPropertyValue(string, "colorset").split(LIST_SEPARATOR);
            colorLibrary = new ListBasedColorLibrary(stringArray, DEFAULT_SCHEME_NAME);
            this.setCached(string, "colorset", colorLibrary);
        }
        return colorLibrary;
    }

    @Override
    public double getLineWidth(String string) {
        Double d = this.getCached(string, "line-width", Double.class);
        if (d == null) {
            try {
                d = FormatUtil.parseDouble(this.getPropertyValue(string, "line-width")) * 100.0;
            }
            catch (NullPointerException nullPointerException) {
                throw new AbortException("Missing/invalid value in style library: " + string + '.' + "line-width");
            }
        }
        return d;
    }

    @Override
    public double getTextSize(String string) {
        Double d = this.getCached(string, "text-size", Double.class);
        if (d == null) {
            try {
                d = FormatUtil.parseDouble(this.getPropertyValue(string, "text-size")) * 100.0;
            }
            catch (NullPointerException nullPointerException) {
                throw new AbortException("Missing/invalid value in style library: " + string + '.' + "text-size");
            }
        }
        return d;
    }

    @Override
    public String getFontFamily(String string) {
        return this.getPropertyValue(string, "font-family");
    }

    @Override
    public double getSize(String string) {
        Double d = this.getCached(string, "size", Double.class);
        if (d == null) {
            try {
                d = FormatUtil.parseDouble(this.getPropertyValue(string, "size")) * 100.0;
            }
            catch (NullPointerException nullPointerException) {
                throw new AbortException("Missing/invalid value in style library: " + string + '.' + "size");
            }
        }
        return d;
    }

    @Override
    public double getOpacity(String string) {
        Double d = this.getCached(string, "opacity", Double.class);
        if (d == null) {
            try {
                d = FormatUtil.parseDouble(this.getPropertyValue(string, "opacity"));
            }
            catch (NullPointerException nullPointerException) {
                throw new AbortException("Missing/invalid value in style library: " + string + '.' + "opacity");
            }
        }
        return d;
    }

    @Override
    public LineStyleLibrary lines() {
        if (this.linelib == null) {
            String string = this.properties.getProperty(PROP_LINES_LIBRARY, SolidLineStyleLibrary.class.getName());
            try {
                Class<?> clazz;
                try {
                    clazz = Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    clazz = Class.forName(LineStyleLibrary.class.getPackage().getName() + '.' + string);
                }
                this.linelib = (LineStyleLibrary)clazz.getConstructor(StyleLibrary.class).newInstance(this);
            }
            catch (Exception exception) {
                LOG.exception(exception);
                this.linelib = new SolidLineStyleLibrary(this);
            }
        }
        return this.linelib;
    }

    @Override
    public MarkerLibrary markers() {
        if (this.markerlib == null) {
            String string = this.properties.getProperty(PROP_MARKER_LIBRARY, PrettyMarkers.class.getName());
            try {
                Class<?> clazz;
                try {
                    clazz = Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    clazz = Class.forName(MarkerLibrary.class.getPackage().getName() + '.' + string);
                }
                this.markerlib = (MarkerLibrary)clazz.getConstructor(StyleLibrary.class).newInstance(this);
            }
            catch (Exception exception) {
                LOG.exception(exception);
                this.markerlib = new PrettyMarkers(this);
            }
        }
        return this.markerlib;
    }
}

