/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.svg;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection2D;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPath;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class SVGHyperCube {
    public static Element drawFrame(SVGPlot sVGPlot, Projection2D projection2D, double[] dArray, double[] dArray2) {
        SVGPath sVGPath = new SVGPath();
        ArrayList<double[]> arrayList = SVGHyperCube.getVisibleEdges(projection2D, dArray, dArray2);
        double[] dArray3 = projection2D.fastProjectDataToRenderSpace(dArray);
        SVGHyperCube.recDrawEdges(sVGPath, dArray3[0], dArray3[1], arrayList, 0, BitsUtil.zero(arrayList.size()));
        return sVGPath.makeElement(sVGPlot);
    }

    public static Element drawFrame(SVGPlot sVGPlot, Projection2D projection2D, NumberVector numberVector, NumberVector numberVector2) {
        SVGPath sVGPath = new SVGPath();
        ArrayList<double[]> arrayList = SVGHyperCube.getVisibleEdges(projection2D, numberVector, numberVector2);
        double[] dArray = projection2D.fastProjectDataToRenderSpace(numberVector);
        SVGHyperCube.recDrawEdges(sVGPath, dArray[0], dArray[1], arrayList, 0, BitsUtil.zero(arrayList.size()));
        return sVGPath.makeElement(sVGPlot);
    }

    public static Element drawFrame(SVGPlot sVGPlot, Projection2D projection2D, SpatialComparable spatialComparable) {
        SVGPath sVGPath = new SVGPath();
        ArrayList<double[]> arrayList = SVGHyperCube.getVisibleEdges(projection2D, spatialComparable);
        int n = spatialComparable.getDimensionality();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = spatialComparable.getMin(i);
        }
        double[] dArray2 = projection2D.fastProjectDataToRenderSpace(dArray);
        SVGHyperCube.recDrawEdges(sVGPath, dArray2[0], dArray2[1], arrayList, 0, BitsUtil.zero(arrayList.size()));
        return sVGPath.makeElement(sVGPlot);
    }

    public static Element drawFilled(SVGPlot sVGPlot, String string, Projection2D projection2D, double[] dArray, double[] dArray2) {
        Element element = sVGPlot.svgElement("g");
        ArrayList<double[]> arrayList = SVGHyperCube.getVisibleEdges(projection2D, dArray, dArray2);
        double[] dArray3 = projection2D.fastProjectDataToRenderSpace(dArray);
        SVGHyperCube.recDrawSides(sVGPlot, element, string, dArray3[0], dArray3[1], arrayList, 0, BitsUtil.zero(arrayList.size()));
        return element;
    }

    public static Element drawFilled(SVGPlot sVGPlot, String string, Projection2D projection2D, NumberVector numberVector, NumberVector numberVector2) {
        Element element = sVGPlot.svgElement("g");
        ArrayList<double[]> arrayList = SVGHyperCube.getVisibleEdges(projection2D, numberVector, numberVector2);
        double[] dArray = projection2D.fastProjectDataToRenderSpace(numberVector);
        SVGHyperCube.recDrawSides(sVGPlot, element, string, dArray[0], dArray[1], arrayList, 0, BitsUtil.zero(arrayList.size()));
        return element;
    }

    public static Element drawFilled(SVGPlot sVGPlot, String string, Projection2D projection2D, SpatialComparable spatialComparable) {
        Element element = sVGPlot.svgElement("g");
        ArrayList<double[]> arrayList = SVGHyperCube.getVisibleEdges(projection2D, spatialComparable);
        int n = spatialComparable.getDimensionality();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = spatialComparable.getMin(i);
        }
        double[] dArray2 = projection2D.fastProjectDataToRenderSpace(dArray);
        SVGHyperCube.recDrawSides(sVGPlot, element, string, dArray2[0], dArray2[1], arrayList, 0, BitsUtil.zero(arrayList.size()));
        return element;
    }

    private static ArrayList<double[]> getVisibleEdges(Projection2D projection2D, double[] dArray, double[] dArray2) {
        int n = dArray.length;
        double[] dArray3 = VMath.minus(dArray2, dArray);
        ArrayList<double[]> arrayList = new ArrayList<double[]>(n);
        for (int i = 0; i < n; ++i) {
            double[] dArray4 = new double[n];
            dArray4[i] = dArray3[i];
            double[] dArray5 = projection2D.fastProjectRelativeDataToRenderSpace(dArray4);
            if (dArray5[0] == 0.0 && dArray5[1] == 0.0) continue;
            arrayList.add(dArray5);
        }
        return arrayList;
    }

    private static ArrayList<double[]> getVisibleEdges(Projection2D projection2D, NumberVector numberVector, NumberVector numberVector2) {
        int n = numberVector.getDimensionality();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = numberVector2.doubleValue(i) - numberVector.doubleValue(i);
        }
        ArrayList<double[]> arrayList = new ArrayList<double[]>(n);
        for (int i = 0; i < n; ++i) {
            double[] dArray2 = new double[n];
            dArray2[i] = dArray[i];
            double[] dArray3 = projection2D.fastProjectRelativeDataToRenderSpace(dArray2);
            if (dArray3[0] == 0.0 && dArray3[1] == 0.0) continue;
            arrayList.add(dArray3);
        }
        return arrayList;
    }

    private static ArrayList<double[]> getVisibleEdges(Projection2D projection2D, SpatialComparable spatialComparable) {
        int n = spatialComparable.getDimensionality();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = spatialComparable.getMax(i) - spatialComparable.getMin(i);
        }
        ArrayList<double[]> arrayList = new ArrayList<double[]>(n);
        for (int i = 0; i < n; ++i) {
            double[] dArray2 = new double[n];
            dArray2[i] = dArray[i];
            double[] dArray3 = projection2D.fastProjectRelativeDataToRenderSpace(dArray2);
            if (dArray3[0] == 0.0 && dArray3[1] == 0.0) continue;
            arrayList.add(dArray3);
        }
        return arrayList;
    }

    private static void recDrawEdges(SVGPath sVGPath, double d, double d2, List<double[]> list, int n, long[] lArray) {
        for (int i = 0; i < list.size(); ++i) {
            double d3;
            double[] dArray;
            double d4;
            if (BitsUtil.get(lArray, i) || !SVGHyperCube.isFinite(d4 = d + (dArray = list.get(i))[0]) || !SVGHyperCube.isFinite(d3 = d2 + dArray[1])) continue;
            sVGPath.moveTo(d, d2);
            sVGPath.drawTo(d4, d3);
            BitsUtil.setI(lArray, i);
            SVGHyperCube.recDrawEdges(sVGPath, d4, d3, list, i + 1, lArray);
            BitsUtil.clearI(lArray, i);
        }
    }

    private static void recDrawSides(SVGPlot sVGPlot, Element element, String string, double d, double d2, List<double[]> list, int n, long[] lArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < list.size() - 1; ++i) {
            double d3;
            double[] dArray;
            double d4;
            if (BitsUtil.get(lArray, i) || !SVGHyperCube.isFinite(d4 = d + (dArray = list.get(i))[0]) || !SVGHyperCube.isFinite(d3 = d2 + dArray[1])) continue;
            for (int j = i + 1; j < list.size(); ++j) {
                if (BitsUtil.get(lArray, j)) continue;
                double[] dArray2 = list.get(j);
                double d5 = dArray2[0];
                if (!SVGHyperCube.isFinite(d4)) continue;
                double d6 = dArray2[1];
                if (!SVGHyperCube.isFinite(d5)) continue;
                stringBuilder.delete(0, stringBuilder.length());
                stringBuilder.append(SVGUtil.fmt(d)).append(',');
                stringBuilder.append(SVGUtil.fmt(d2)).append(' ');
                stringBuilder.append(SVGUtil.fmt(d4)).append(',');
                stringBuilder.append(SVGUtil.fmt(d3)).append(' ');
                stringBuilder.append(SVGUtil.fmt(d4 + d5)).append(',');
                stringBuilder.append(SVGUtil.fmt(d3 + d6)).append(' ');
                stringBuilder.append(SVGUtil.fmt(d + d5)).append(',');
                stringBuilder.append(SVGUtil.fmt(d2 + d6));
                Element element2 = sVGPlot.svgElement("polygon");
                SVGUtil.setAtt(element2, "points", stringBuilder.toString());
                SVGUtil.setCSSClass(element2, string);
                element.appendChild(element2);
            }
            BitsUtil.setI(lArray, i);
            SVGHyperCube.recDrawSides(sVGPlot, element, string, d4, d3, list, i + 1, lArray);
            BitsUtil.clearI(lArray, i);
        }
    }

    private static boolean isFinite(double d) {
        return d < Double.POSITIVE_INFINITY && d > Double.NEGATIVE_INFINITY;
    }
}

