/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.pairsegments;

import de.lmu.ifi.dbs.elki.evaluation.clustering.pairsegments.Segment;
import de.lmu.ifi.dbs.elki.evaluation.clustering.pairsegments.Segments;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultListener;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGCheckbox;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.pairsegments.SegmentsStylingPolicy;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MouseEvent;

@Reference(title="Evaluation of Clusterings \u2013 Metrics and Visual Support", authors="Elke Achtert, Sascha Goldhofer, Hans-Peter Kriegel, Erich Schubert, Arthur Zimek", booktitle="Proc. 28th International Conference on Data Engineering (ICDE) 2012", url="http://dx.doi.org/10.1109/ICDE.2012.128")
public class CircleSegmentsVisualizer
extends AbstractVisFactory {
    private static final Logging LOG = Logging.getLogger(CircleSegmentsVisualizer.class);
    private static final String NAME = "CircleSegments";

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2, projection);
    }

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        Hierarchy.Iter<Segments> iter = VisualizationTree.filterResults(visualizerContext, object, Segments.class);
        while (iter.valid()) {
            SegmentsStylingPolicy segmentsStylingPolicy;
            Segments segments = iter.get();
            Hierarchy.Iter<SegmentsStylingPolicy> iter2 = VisualizationTree.filter(visualizerContext, segments, SegmentsStylingPolicy.class);
            if (iter2.valid()) {
                segmentsStylingPolicy = iter2.get();
            } else {
                segmentsStylingPolicy = new SegmentsStylingPolicy(segments);
                visualizerContext.addVis(segments, segmentsStylingPolicy);
            }
            VisualizationTask visualizationTask = new VisualizationTask(NAME, visualizerContext, segmentsStylingPolicy, null, this);
            visualizationTask.reqwidth = 2.0;
            visualizationTask.reqheight = 2.0;
            visualizationTask.level = 1000;
            visualizationTask.addUpdateFlags(4);
            visualizerContext.addVis(segments, visualizationTask);
            iter.advance();
        }
    }

    public class Instance
    extends AbstractVisualization
    implements ResultListener {
        private static final double SEGMENT_MIN_ANGLE = 0.01;
        private static final double SEGMENT_MIN_SEP_ANGLE = 0.005;
        private static final double RADIUS_INNER = 4.0;
        private static final double RADIUS_DISTANCE = 1.0;
        private static final double RADIUS_OUTER = 47.0;
        private static final double RADIUS_SELECTION = 2.0;
        private static final String CLR_CLUSTER_CLASS_PREFIX = "clusterSegment";
        public static final String CLR_BORDER_CLASS = "clusterBorder";
        public static final String CLR_UNPAIRED_CLASS = "clusterUnpaired";
        public static final String CLR_HOVER_CLASS = "clusterHover";
        public static final String SEG_UNPAIRED_SELECTED_CLASS = "unpairedSegmentSelected";
        public static final String STYLE = "segments";
        public static final String STYLE_BORDER = "segments.border";
        public static final String STYLE_HOVER = "segments.hover";
        public static final String STYLE_GRADIENT_FIRST = "segments.cluster.first";
        public static final String STYLE_GRADIENT_SECOND = "segments.cluster.second";
        protected final Segments segments;
        private Element visLayer;
        private Element ctrlLayer;
        public Map<Segment, List<Element>> segmentToElements;
        boolean showUnclusteredPairs;
        protected final SegmentsStylingPolicy policy;
        private boolean noIncrementalRedraw;

        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
            super(visualizationTask, visualizationPlot, d, d2);
            this.segmentToElements = new HashMap<Segment, List<Element>>();
            this.showUnclusteredPairs = false;
            this.noIncrementalRedraw = true;
            this.policy = (SegmentsStylingPolicy)visualizationTask.getResult();
            this.segments = this.policy.segments;
            this.policy.setStyleLibrary(this.context.getStyleLibrary());
            this.addListeners();
        }

        public void toggleUnclusteredPairs(boolean bl) {
            this.noIncrementalRedraw = true;
            this.showUnclusteredPairs = bl;
            this.svgp.requestRedraw(this.task, this);
        }

        @Override
        public void resultChanged(Result result) {
            super.resultChanged(result);
            if (result == this.context.getStylingPolicy() && this.context.getStylingPolicy() != this.policy) {
                this.policy.deselectAllSegments();
            }
        }

        @Override
        public void incrementalRedraw() {
            if (this.noIncrementalRedraw) {
                super.incrementalRedraw();
            } else {
                this.redrawSelection();
            }
        }

        @Override
        public void fullRedraw() {
            LOG.debug("Full redraw");
            this.noIncrementalRedraw = false;
            this.addCSSClasses(this.segments.getHighestClusterCount());
            this.layer = this.svgp.svgElement("g");
            this.visLayer = this.svgp.svgElement("g");
            String string = SVGUtil.makeMarginTransform(this.task.reqwidth, this.task.reqheight, 100.0, 100.0, 0.0) + "  translate(" + 50.0 + " " + 50.0 + ")";
            this.visLayer.setAttribute("transform", string);
            this.ctrlLayer = this.svgp.svgElement("g");
            this.drawSegments();
            SVGCheckbox sVGCheckbox = new SVGCheckbox(this.showUnclusteredPairs, "Show unclustered pairs");
            sVGCheckbox.addCheckBoxListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    Instance.this.toggleUnclusteredPairs(((SVGCheckbox)changeEvent.getSource()).isChecked());
                }
            });
            Element element = this.drawClusteringInfo();
            Element element2 = sVGCheckbox.renderCheckBox(this.svgp, 1.0, 5.0 + FormatUtil.parseDouble(element.getAttribute("height")), 11.0);
            this.ctrlLayer.appendChild(element);
            this.ctrlLayer.appendChild(element2);
            this.ctrlLayer.setAttribute("transform", "scale(0.0025)");
            this.layer.appendChild(this.visLayer);
            this.layer.appendChild(this.ctrlLayer);
        }

        protected void addCSSClasses(int n) {
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            CSSClass cSSClass = new CSSClass(this.getClass(), CLR_BORDER_CLASS);
            cSSClass.setStatement("fill", styleLibrary.getColor(STYLE_BORDER));
            this.svgp.addCSSClassOrLogError(cSSClass);
            CSSClass cSSClass2 = new CSSClass(this.getClass(), CLR_HOVER_CLASS);
            cSSClass2.setStatement("fill", styleLibrary.getColor(STYLE_HOVER) + " !important");
            cSSClass2.setStatement("cursor", "pointer");
            this.svgp.addCSSClassOrLogError(cSSClass2);
            CSSClass cSSClass3 = new CSSClass(this.getClass(), CLR_UNPAIRED_CLASS);
            cSSClass3.setStatement("fill", styleLibrary.getBackgroundColor(STYLE));
            cSSClass3.setStatement("stroke", "none");
            this.svgp.addCSSClassOrLogError(cSSClass3);
            CSSClass cSSClass4 = new CSSClass(this.getClass(), SEG_UNPAIRED_SELECTED_CLASS);
            cSSClass4.setStatement("fill", styleLibrary.getColor(STYLE_HOVER) + " !important");
            this.svgp.addCSSClassOrLogError(cSSClass4);
            String string = styleLibrary.getColor(STYLE_GRADIENT_FIRST);
            String string2 = styleLibrary.getColor(STYLE_GRADIENT_SECOND);
            String[] stringArray = this.makeGradient(n, new String[]{string, string2});
            for (int i = 0; i < n; ++i) {
                CSSClass cSSClass5 = new CSSClass(CircleSegmentsVisualizer.class, "clusterSegment_" + i);
                cSSClass5.setStatement("fill", stringArray[i]);
                cSSClass5.setStatement("stroke", "none");
                this.svgp.addCSSClassOrLogError(cSSClass5);
            }
        }

        private void drawSegments() {
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            int n = this.segments.getClusterings();
            this.segmentToElements.clear();
            double d = (Math.PI * 2 - 0.005 * (double)this.segments.size()) / (double)this.segments.getPairCount(this.showUnclusteredPairs);
            int n2 = (int)Math.ceil(0.01 / d);
            int n3 = 0;
            for (Segment segment : this.segments) {
                if (segment.getPairCount() > (long)n2) continue;
                ++n3;
            }
            d = (Math.PI * 2 - (0.005 * (double)this.segments.size() + (double)n3 * 0.01)) / (double)(this.segments.getPairCount(this.showUnclusteredPairs) - n3);
            double d2 = (43.0 - (double)n * 1.0) / (double)n;
            double d3 = 0.005;
            int n4 = 0;
            int n5 = -1;
            double d4 = 0.0;
            for (Segment segment : this.segments) {
                Object object;
                int n6;
                long l = segment.getPairCount();
                double d5 = 0.01;
                if (l > (long)n2) {
                    d5 = d * (double)l;
                }
                ArrayList<Element> arrayList = new ArrayList<Element>(n);
                this.segmentToElements.put(segment, arrayList);
                for (int i = 0; i < n; ++i) {
                    double d6 = (double)i * (d2 + 1.0) + 4.0;
                    if (n5 != segment.get(n4) && n4 == i) {
                        Element element = SVGUtil.svgCircleSegment(this.svgp, 0.0, 0.0, d4 - 0.005, d3, d6, 46.0);
                        element.setAttribute("class", CLR_BORDER_CLASS);
                        this.visLayer.appendChild(element);
                        if (segment.get(n4) == -1) {
                            n4 = Math.min(n4 + 1, n - 1);
                        }
                        n5 = segment.get(n4);
                    }
                    n6 = segment.get(i);
                    object = SVGUtil.svgCircleSegment(this.svgp, 0.0, 0.0, d4, d5, d6, d6 + d2);
                    arrayList.add((Element)object);
                    SegmentListenerProxy segmentListenerProxy = new SegmentListenerProxy(segment, i);
                    EventTarget eventTarget = (EventTarget)object;
                    eventTarget.addEventListener("mouseover", segmentListenerProxy, false);
                    eventTarget.addEventListener("mouseout", segmentListenerProxy, false);
                    eventTarget.addEventListener("click", segmentListenerProxy, false);
                    if (n6 >= 0) {
                        object.setAttribute("class", "clusterSegment_" + n6);
                    } else {
                        object.setAttribute("class", CLR_UNPAIRED_CLASS);
                    }
                    this.visLayer.appendChild((Node)object);
                }
                double d7 = (double)n * (d2 + 1.0) + 4.0;
                Element element = SVGUtil.svgCircleSegment(this.svgp, 0.0, 0.0, d4, d5, d7, d7 + 2.0);
                element.setAttribute("class", CLR_UNPAIRED_CLASS);
                arrayList.add(element);
                if (segment.isUnpaired()) {
                    if (this.policy.isSelected(segment)) {
                        SVGUtil.addCSSClass(element, SEG_UNPAIRED_SELECTED_CLASS);
                    } else {
                        SVGUtil.removeCSSClass(element, SEG_UNPAIRED_SELECTED_CLASS);
                    }
                } else {
                    n6 = this.policy.indexOfSegment(segment);
                    if (n6 >= 0) {
                        object = styleLibrary.getColorSet("plot").getColor(n6);
                        element.setAttribute("style", "fill:" + (String)object);
                    } else {
                        element.removeAttribute("style");
                    }
                }
                this.visLayer.appendChild(element);
                d4 += d5 + 0.005;
            }
        }

        private void redrawSelection() {
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            LOG.debug("Updating selection only.");
            for (Map.Entry<Segment, List<Element>> entry : this.segmentToElements.entrySet()) {
                Segment segment = entry.getKey();
                Element element = entry.getValue().get(this.segments.getClusterings());
                if (segment.isUnpaired()) {
                    if (this.policy.isSelected(segment)) {
                        SVGUtil.addCSSClass(element, SEG_UNPAIRED_SELECTED_CLASS);
                        continue;
                    }
                    SVGUtil.removeCSSClass(element, SEG_UNPAIRED_SELECTED_CLASS);
                    continue;
                }
                int n = this.policy.indexOfSegment(segment);
                if (n >= 0) {
                    String string = styleLibrary.getColorSet("plot").getColor(n);
                    element.setAttribute("style", "fill:" + string);
                    continue;
                }
                element.removeAttribute("style");
            }
        }

        protected String[] makeGradient(int n, String[] stringArray) {
            if (n <= stringArray.length) {
                return stringArray;
            }
            Color[] colorArray = new Color[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                colorArray[i] = SVGUtil.stringToColor(stringArray[i]);
                if (colorArray[i] != null) continue;
                throw new AbortException("Error parsing color: " + stringArray[i]);
            }
            double d = ((double)colorArray.length - 1.0) / (double)n;
            String[] stringArray2 = new String[n];
            for (int i = 0; i < n; ++i) {
                int n2;
                int n3 = Math.min((int)Math.floor(d * (double)i), colorArray.length);
                if (n3 == (n2 = Math.min((int)Math.ceil(d * (double)i), colorArray.length))) {
                    stringArray2[i] = stringArray[n3];
                    continue;
                }
                Color color = colorArray[n3];
                Color color2 = colorArray[n2];
                double d2 = (d * (double)i - (double)n3) / (double)(n2 - n3);
                int n4 = (int)((1.0 - d2) * (double)color.getRed() + d2 * (double)color2.getRed());
                int n5 = (int)((1.0 - d2) * (double)color.getGreen() + d2 * (double)color2.getGreen());
                int n6 = (int)((1.0 - d2) * (double)color.getBlue() + d2 * (double)color2.getBlue());
                stringArray2[i] = SVGUtil.colorToString((n4 & 0xFF) << 16 | (n5 & 0xFF) << 8 | n6 & 0xFF);
            }
            return stringArray2;
        }

        protected Element drawClusteringInfo() {
            Element element = SVGUtil.svgElement(this.svgp.getDocument(), "g");
            int n = 4;
            int n2 = 12;
            int n3 = 4;
            int n4 = this.segments.getClusterings() * (n2 + n3) + n;
            SVGUtil.setAtt(element, "height", n4);
            for (int i = 0; i < this.segments.getClusterings(); ++i) {
                double d = i * n2 + n3 * i + n;
                Element element2 = SVGUtil.svgCircleSegment(this.svgp, n4 - n, n4 - n, 4.71238898038469, 1.5707963267948966, d, d + (double)n2);
                element2.setAttribute("fill", "#d4e4f1");
                element2.setAttribute("stroke", "#a0a0a0");
                element2.setAttribute("stroke-width", "1.0");
                String string = this.segments.getClusteringDescription(i);
                Element element3 = this.svgp.svgText(n4 + n, (double)n4 - d - (double)n, string);
                element.appendChild(element3);
                element.appendChild(element2);
            }
            return element;
        }

        protected void segmentHover(Segment segment, int n, boolean bl) {
            if (bl) {
                if (segment.isNone()) {
                    return;
                }
                if (LOG.isDebugging()) {
                    LOG.debug("Hover on segment: " + segment + " unpaired: " + segment.isUnpaired());
                }
                if (!segment.isUnpaired()) {
                    for (Map.Entry<Segment, List<Element>> entry : this.segmentToElements.entrySet()) {
                        Segment segment2 = entry.getKey();
                        if (segment2.get(n) != segment.get(n)) continue;
                        Element element = entry.getValue().get(n);
                        SVGUtil.addCSSClass(element, CLR_HOVER_CLASS);
                    }
                } else {
                    List<Segment> list = this.segments.getPairedSegments(segment);
                    for (Segment segment3 : list) {
                        Element element = this.segmentToElements.get(segment3).get(n);
                        SVGUtil.addCSSClass(element, CLR_HOVER_CLASS);
                    }
                }
            } else {
                for (List<Element> list : this.segmentToElements.values()) {
                    for (Element element : list) {
                        SVGUtil.removeCSSClass(element, CLR_HOVER_CLASS);
                    }
                }
            }
        }

        protected void segmentClick(Segment segment, Event event, boolean bl) {
            MouseEvent mouseEvent = (MouseEvent)event;
            boolean bl2 = false;
            if (mouseEvent.getCtrlKey()) {
                bl2 = true;
            }
            if (bl) {
                this.policy.deselectAllSegments();
            }
            this.policy.select(segment, bl2);
            this.context.setStylingPolicy(this.policy);
        }

        private class SegmentListenerProxy
        implements EventListener {
            public static final int EVT_DBLCLICK_DELAY = 350;
            private Segment id;
            private int ringid;
            private long lastClick = 0L;

            public SegmentListenerProxy(Segment segment, int n) {
                this.id = segment;
                this.ringid = n;
            }

            @Override
            public void handleEvent(Event event) {
                if ("mouseover".equals(event.getType())) {
                    Instance.this.segmentHover(this.id, this.ringid, true);
                }
                if ("mouseout".equals(event.getType())) {
                    Instance.this.segmentHover(this.id, this.ringid, false);
                }
                if ("click".equals(event.getType())) {
                    boolean bl = false;
                    long l = Calendar.getInstance().getTimeInMillis();
                    if (l - this.lastClick <= 350L) {
                        bl = true;
                    }
                    this.lastClick = l;
                    Instance.this.segmentClick(this.id, event, bl);
                }
            }
        }
    }
}

