/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.parallel.cluster;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreListener;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.colors.ColorLibrary;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ParallelPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.ClusterStylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.StylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPath;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.parallel.AbstractParallelVisualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.cluster.ClusterHullVisualization;
import java.util.Iterator;
import org.w3c.dom.Element;

public class ClusterOutlineVisualization
extends AbstractVisFactory {
    private static final String NAME = "Cluster Hull (Parallel Coordinates)";
    Parameterizer settings;

    public ClusterOutlineVisualization(Parameterizer parameterizer) {
        this.settings = parameterizer;
    }

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2, projection);
    }

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        Hierarchy.Iter<ParallelPlotProjector> iter = VisualizationTree.filter(visualizerContext, object, ParallelPlotProjector.class);
        while (iter.valid()) {
            ParallelPlotProjector parallelPlotProjector = iter.get();
            Relation relation = parallelPlotProjector.getRelation();
            if (TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(relation.getDataTypeInformation())) {
                VisualizationTask visualizationTask = new VisualizationTask(NAME, visualizerContext, parallelPlotProjector, relation, this);
                visualizationTask.level = 99;
                visualizationTask.initDefaultVisibility(false);
                visualizationTask.addUpdateFlags(5);
                visualizerContext.addVis(parallelPlotProjector, visualizationTask);
            }
            iter.advance();
        }
    }

    @Override
    public boolean allowThumbnails(VisualizationTask visualizationTask) {
        return false;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID STRAIGHT_ID = new OptionID("parallel.clusteroutline.straight", "Draw straight lines");
        double alpha = Double.POSITIVE_INFINITY;
        private boolean bend = true;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            Flag flag;
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter = new DoubleParameter(ClusterHullVisualization.Parameterizer.ALPHA_ID, Double.POSITIVE_INFINITY);
            if (parameterization.grab(doubleParameter)) {
                this.alpha = doubleParameter.doubleValue();
            }
            if (parameterization.grab(flag = new Flag(STRAIGHT_ID))) {
                this.bend = flag.isFalse();
            }
        }

        @Override
        protected ClusterOutlineVisualization makeInstance() {
            return new ClusterOutlineVisualization(this);
        }
    }

    public class Instance
    extends AbstractParallelVisualization<NumberVector>
    implements DataStoreListener {
        public static final String CLUSTERAREA = "Clusteroutline";

        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
            super(visualizationTask, visualizationPlot, d, d2, projection);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            super.fullRedraw();
            StylingPolicy stylingPolicy = this.context.getStylingPolicy();
            if (!(stylingPolicy instanceof ClusterStylingPolicy)) {
                return;
            }
            ClusterStylingPolicy clusterStylingPolicy = (ClusterStylingPolicy)stylingPolicy;
            Clustering<?> clustering = clusterStylingPolicy.getClustering();
            int n = this.proj.getVisibleDimensions();
            DoubleMinMax[] doubleMinMaxArray = DoubleMinMax.newArray(n);
            DoubleMinMax[] doubleMinMaxArray2 = DoubleMinMax.newArray(n - 1);
            double d = 0.5;
            Iterator<Cluster<?>> iterator = clustering.getAllClusters().iterator();
            for (int i = 0; i < clustering.getAllClusters().size(); ++i) {
                int n2;
                Cluster<?> cluster = iterator.next();
                DBIDs dBIDs = cluster.getIDs();
                if (dBIDs.size() < 1) continue;
                for (int j = 0; j < n; ++j) {
                    doubleMinMaxArray[j].reset();
                    if (j >= n - 1) continue;
                    doubleMinMaxArray2[j].reset();
                }
                Object object = dBIDs.iter();
                while (object.valid()) {
                    double[] dArray = this.proj.fastProjectDataToRenderSpace((NumberVector)this.relation.get((DBIDRef)object));
                    for (int j = 0; j < n; ++j) {
                        doubleMinMaxArray[j].put(dArray[j]);
                        if (j <= 0) continue;
                        doubleMinMaxArray2[j - 1].put((dArray[j] + dArray[j - 1]) / 2.0);
                    }
                    object.advance();
                }
                object = new SVGPath();
                if (!ClusterOutlineVisualization.this.settings.bend) {
                    for (n2 = 0; n2 < n; ++n2) {
                        ((SVGPath)object).drawTo(this.getVisibleAxisX(n2), doubleMinMaxArray[n2].getMax());
                        if (n2 >= n - 1) continue;
                        ((SVGPath)object).drawTo(this.getVisibleAxisX((double)n2 + 0.5), doubleMinMaxArray2[n2].getMax());
                    }
                    for (n2 = n - 1; n2 >= 0; --n2) {
                        if (n2 < n - 1) {
                            ((SVGPath)object).drawTo(this.getVisibleAxisX((double)n2 + 0.5), doubleMinMaxArray2[n2].getMin());
                        }
                        ((SVGPath)object).drawTo(this.getVisibleAxisX(n2), doubleMinMaxArray[n2].getMin());
                    }
                } else {
                    ((SVGPath)object).drawTo(this.getVisibleAxisX(0.0), doubleMinMaxArray[0].getMax());
                    for (n2 = 1; n2 < n; ++n2) {
                        ((SVGPath)object).quadTo(this.getVisibleAxisX((double)n2 - 0.5), doubleMinMaxArray2[n2 - 1].getMax(), this.getVisibleAxisX(n2), doubleMinMaxArray[n2].getMax());
                    }
                    ((SVGPath)object).drawTo(this.getVisibleAxisX(n - 1), doubleMinMaxArray[n - 1].getMin());
                    for (n2 = n - 1; n2 > 0; --n2) {
                        ((SVGPath)object).quadTo(this.getVisibleAxisX((double)n2 - 0.5), doubleMinMaxArray2[n2 - 1].getMin(), this.getVisibleAxisX(n2 - 1), doubleMinMaxArray[n2 - 1].getMin());
                    }
                }
                ((SVGPath)object).close();
                double d2 = 0.0;
                for (int j = 0; j < n; ++j) {
                    d2 += doubleMinMaxArray[j].getDiff();
                }
                d2 = d2 > 0.0 ? (double)n * 100.0 / d2 : 1.0;
                Element element = ((SVGPath)object).makeElement(this.svgp);
                this.addCSSClasses(this.svgp, clusterStylingPolicy.getStyleForCluster(cluster), d * d2 * (double)dBIDs.size() / (double)this.relation.size());
                SVGUtil.addCSSClass(element, CLUSTERAREA + i);
                this.layer.appendChild(element);
            }
        }

        private void addCSSClasses(SVGPlot sVGPlot, int n, double d) {
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            ColorLibrary colorLibrary = styleLibrary.getColorSet("plot");
            CSSClass cSSClass = new CSSClass(this, CLUSTERAREA + n);
            String string = colorLibrary.getColor(n);
            cSSClass.setStatement("fill", string);
            cSSClass.setStatement("fill-opacity", d);
            sVGPlot.addCSSClassOrLogError(cSSClass);
        }
    }
}

