/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.outlier;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreListener;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.scaling.ScalingFunction;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierScalingFunction;
import de.lmu.ifi.dbs.elki.visualization.VisualizationItem;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.colors.ColorLibrary;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.ClassStylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.StylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import org.w3c.dom.Element;

@Reference(authors="E. Achtert, H.-P. Kriegel, L. Reichert, E. Schubert, R. Wojdanowski, A. Zimek", title="Visual Evaluation of Outlier Detection Models", booktitle="Proceedings of the 15th International Conference on Database Systems for Advanced Applications (DASFAA), Tsukuba, Japan, 2010", url="http://dx.doi.org/10.1007/978-3-642-12098-5_34")
public class BubbleVisualization
extends AbstractVisFactory {
    public static final String BUBBLE = "bubble";
    public static final String NAME = "Outlier Bubbles";
    protected Parameterizer settings;

    public BubbleVisualization(Parameterizer parameterizer) {
        this.settings = parameterizer;
    }

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        if (this.settings.scaling != null && this.settings.scaling instanceof OutlierScalingFunction) {
            OutlierResult outlierResult = (OutlierResult)visualizationTask.getResult();
            ((OutlierScalingFunction)this.settings.scaling).prepare(outlierResult);
        }
        return new Instance(visualizationTask, visualizationPlot, d, d2, projection);
    }

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        VisualizationTree.findNewSiblings(visualizerContext, object, OutlierResult.class, ScatterPlotProjector.class, new VisualizationTree.Handler2<OutlierResult, ScatterPlotProjector<?>>(){

            @Override
            public void process(VisualizerContext visualizerContext, OutlierResult outlierResult, ScatterPlotProjector<?> scatterPlotProjector) {
                Relation<?> relation = scatterPlotProjector.getRelation();
                if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(relation.getDataTypeInformation())) {
                    return;
                }
                boolean bl = true;
                Object object = outlierResult.getHierarchy().iterParents(outlierResult);
                while (object.valid()) {
                    if (object.get() instanceof OutlierResult) {
                        bl = false;
                        break;
                    }
                    object.advance();
                }
                object = new VisualizationTask(BubbleVisualization.NAME, visualizerContext, outlierResult, relation, BubbleVisualization.this);
                ((VisualizationTask)object).level = 100;
                ((VisualizationTask)object).addUpdateFlags(13);
                ((VisualizationTask)object).initDefaultVisibility(bl);
                visualizerContext.addVis(outlierResult, (VisualizationItem)object);
                visualizerContext.addVis(scatterPlotProjector, (VisualizationItem)object);
            }
        });
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID FILL_ID = new OptionID("bubble.fill", "Half-transparent filling of bubbles.");
        public static final OptionID SCALING_ID = new OptionID("bubble.scaling", "Additional scaling function for bubbles.");
        protected boolean fill;
        protected ScalingFunction scaling;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            ObjectParameter objectParameter;
            super.makeOptions(parameterization);
            Flag flag = new Flag(FILL_ID);
            if (parameterization.grab(flag)) {
                this.fill = flag.isTrue();
            }
            if (parameterization.grab(objectParameter = new ObjectParameter(SCALING_ID, OutlierScalingFunction.class, true))) {
                this.scaling = (ScalingFunction)objectParameter.instantiateClass(parameterization);
            }
        }

        @Override
        protected BubbleVisualization makeInstance() {
            return new BubbleVisualization(this);
        }
    }

    public class Instance
    extends AbstractScatterplotVisualization
    implements DataStoreListener {
        protected OutlierResult result;

        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
            super(visualizationTask, visualizationPlot, d, d2, projection);
            this.result = (OutlierResult)visualizationTask.getResult();
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            this.setupCanvas();
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            StylingPolicy stylingPolicy = this.context.getStylingPolicy();
            double d = styleLibrary.getSize("plot.bubble");
            if (stylingPolicy instanceof ClassStylingPolicy) {
                ClassStylingPolicy classStylingPolicy = (ClassStylingPolicy)stylingPolicy;
                this.setupCSS(this.svgp, classStylingPolicy);
                DBIDIter dBIDIter = this.sample.getSample().iter();
                while (dBIDIter.valid()) {
                    double[] dArray;
                    NumberVector numberVector;
                    double d2 = this.getScaledForId(dBIDIter);
                    if (d2 > 0.01 && !Double.isInfinite(d2) && (numberVector = (NumberVector)this.rel.get(dBIDIter)) != null && (dArray = this.proj.fastProjectDataToRenderSpace(numberVector))[0] == dArray[0] && dArray[1] == dArray[1]) {
                        Element element = this.svgp.svgCircle(dArray[0], dArray[1], d2 * d);
                        SVGUtil.addCSSClass(element, BubbleVisualization.BUBBLE + classStylingPolicy.getStyleForDBID(dBIDIter));
                        this.layer.appendChild(element);
                    }
                    dBIDIter.advance();
                }
            } else {
                DBIDIter dBIDIter = this.sample.getSample().iter();
                while (dBIDIter.valid()) {
                    double[] dArray;
                    NumberVector numberVector;
                    double d3 = this.getScaledForId(dBIDIter);
                    if (d3 > 0.01 && !Double.isInfinite(d3) && (numberVector = (NumberVector)this.rel.get(dBIDIter)) != null && (dArray = this.proj.fastProjectDataToRenderSpace(numberVector))[0] == dArray[0] && dArray[1] == dArray[1]) {
                        Element element = this.svgp.svgCircle(dArray[0], dArray[1], d3 * d);
                        int n = stylingPolicy.getColorForDBID(dBIDIter);
                        StringBuilder stringBuilder = new StringBuilder();
                        if (BubbleVisualization.this.settings.fill) {
                            stringBuilder.append("fill").append(':').append(SVGUtil.colorToString(n));
                            stringBuilder.append("fill-opacity").append(":0.5");
                        } else {
                            stringBuilder.append("stroke").append(':').append(SVGUtil.colorToString(n));
                            stringBuilder.append("fill").append(':').append("none");
                        }
                        SVGUtil.setAtt(element, "style", stringBuilder.toString());
                        this.layer.appendChild(element);
                    }
                    dBIDIter.advance();
                }
            }
        }

        private void setupCSS(SVGPlot sVGPlot, ClassStylingPolicy classStylingPolicy) {
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            ColorLibrary colorLibrary = styleLibrary.getColorSet("plot");
            for (int i = classStylingPolicy.getMinStyle(); i < classStylingPolicy.getMaxStyle(); ++i) {
                CSSClass cSSClass = new CSSClass(sVGPlot, BubbleVisualization.BUBBLE + i);
                cSSClass.setStatement("stroke-width", styleLibrary.getLineWidth("plot"));
                String string = colorLibrary.getColor(i);
                if (BubbleVisualization.this.settings.fill) {
                    cSSClass.setStatement("fill", string);
                    cSSClass.setStatement("fill-opacity", 0.5);
                } else {
                    cSSClass.setStatement("stroke", string);
                    cSSClass.setStatement("fill", "none");
                }
                sVGPlot.addCSSClassOrLogError(cSSClass);
            }
        }

        protected double getScaledForId(DBIDRef dBIDRef) {
            double d = this.result.getScores().doubleValue(dBIDRef);
            if (Double.isNaN(d) || Double.isInfinite(d)) {
                return 0.0;
            }
            if (BubbleVisualization.this.settings.scaling == null) {
                return this.result.getOutlierMeta().normalizeScore(d);
            }
            return BubbleVisualization.this.settings.scaling.getScaled(d);
        }
    }
}

