/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.selection;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.result.DBIDSelection;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.batikutil.DragableArea;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection2D;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import org.apache.batik.dom.events.DOMMouseEvent;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.svg.SVGPoint;

public class SelectionToolDotVisualization
extends AbstractVisFactory {
    private static final String NAME = "Object Selection";

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2, projection);
    }

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        Hierarchy.Iter<ScatterPlotProjector> iter = VisualizationTree.filter(visualizerContext, object, ScatterPlotProjector.class);
        while (iter.valid()) {
            ScatterPlotProjector scatterPlotProjector = iter.get();
            Relation relation = scatterPlotProjector.getRelation();
            if (TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(relation.getDataTypeInformation())) {
                VisualizationTask visualizationTask = new VisualizationTask(NAME, visualizerContext, visualizerContext.getSelectionResult(), relation, this);
                visualizationTask.level = 1000;
                visualizationTask.tool = true;
                visualizationTask.addFlags(5);
                visualizationTask.addUpdateFlags(3);
                visualizationTask.initDefaultVisibility(false);
                visualizerContext.addVis(visualizerContext.getSelectionResult(), visualizationTask);
                visualizerContext.addVis(scatterPlotProjector, visualizationTask);
            }
            iter.advance();
        }
    }

    public class Instance
    extends AbstractScatterplotVisualization
    implements DragableArea.DragListener {
        private static final String CSS_RANGEMARKER = "selectionRangeMarker";
        Element rtag;
        Element etag;

        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
            super(visualizationTask, visualizationPlot, d, d2, projection);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            this.setupCanvas();
            this.addCSSClasses(this.svgp);
            this.rtag = this.svgp.svgElement("g");
            SVGUtil.addCSSClass(this.rtag, CSS_RANGEMARKER);
            this.layer.appendChild(this.rtag);
            DragableArea dragableArea = new DragableArea((SVGPlot)this.svgp, -60.0, -70.0, 130.0, 140.0, this);
            this.etag = dragableArea.getElement();
            this.layer.appendChild(this.etag);
        }

        private void deleteChildren(Element element) {
            while (element.hasChildNodes()) {
                element.removeChild(element.getLastChild());
            }
        }

        @Override
        public boolean startDrag(SVGPoint sVGPoint, Event event) {
            return true;
        }

        @Override
        public boolean duringDrag(SVGPoint sVGPoint, SVGPoint sVGPoint2, Event event, boolean bl) {
            this.deleteChildren(this.rtag);
            double d = Math.min(sVGPoint.getX(), sVGPoint2.getX());
            double d2 = Math.min(sVGPoint.getY(), sVGPoint2.getY());
            double d3 = Math.abs(sVGPoint.getX() - sVGPoint2.getX());
            double d4 = Math.abs(sVGPoint.getY() - sVGPoint2.getY());
            this.rtag.appendChild(this.svgp.svgRect(d, d2, d3, d4));
            return true;
        }

        @Override
        public boolean endDrag(SVGPoint sVGPoint, SVGPoint sVGPoint2, Event event, boolean bl) {
            Mode mode = this.getInputMode(event);
            this.deleteChildren(this.rtag);
            if (sVGPoint.getX() != sVGPoint2.getX() || sVGPoint.getY() != sVGPoint2.getY()) {
                this.updateSelection(mode, this.proj, sVGPoint, sVGPoint2);
            }
            return true;
        }

        private Mode getInputMode(Event event) {
            if (event instanceof DOMMouseEvent) {
                DOMMouseEvent dOMMouseEvent = (DOMMouseEvent)event;
                if (dOMMouseEvent.getShiftKey()) {
                    return Mode.ADD;
                }
                if (dOMMouseEvent.getCtrlKey()) {
                    return Mode.INVERT;
                }
                return Mode.REPLACE;
            }
            return Mode.REPLACE;
        }

        private void updateSelection(Mode mode, Projection2D projection2D, SVGPoint sVGPoint, SVGPoint sVGPoint2) {
            DBIDSelection dBIDSelection = this.context.getSelection();
            HashSetModifiableDBIDs hashSetModifiableDBIDs = dBIDSelection == null || mode == Mode.REPLACE ? DBIDUtil.newHashSet() : DBIDUtil.newHashSet(dBIDSelection.getSelectedIds());
            DBIDIter dBIDIter = this.rel.iterDBIDs();
            while (dBIDIter.valid()) {
                double[] dArray = projection2D.fastProjectDataToRenderSpace((NumberVector)this.rel.get(dBIDIter));
                if (dArray[0] >= (double)Math.min(sVGPoint.getX(), sVGPoint2.getX()) && dArray[0] <= (double)Math.max(sVGPoint.getX(), sVGPoint2.getX()) && dArray[1] >= (double)Math.min(sVGPoint.getY(), sVGPoint2.getY()) && dArray[1] <= (double)Math.max(sVGPoint.getY(), sVGPoint2.getY())) {
                    if (mode == Mode.INVERT) {
                        if (!hashSetModifiableDBIDs.contains(dBIDIter)) {
                            hashSetModifiableDBIDs.add(dBIDIter);
                        } else {
                            hashSetModifiableDBIDs.remove(dBIDIter);
                        }
                    } else {
                        hashSetModifiableDBIDs.add(dBIDIter);
                    }
                }
                dBIDIter.advance();
            }
            this.context.setSelection(new DBIDSelection(hashSetModifiableDBIDs));
        }

        protected void addCSSClasses(SVGPlot sVGPlot) {
            if (!sVGPlot.getCSSClassManager().contains(CSS_RANGEMARKER)) {
                CSSClass cSSClass = new CSSClass(this, CSS_RANGEMARKER);
                StyleLibrary styleLibrary = this.context.getStyleLibrary();
                cSSClass.setStatement("fill", styleLibrary.getColor("plot.selection.active"));
                cSSClass.setStatement("opacity", styleLibrary.getOpacity("plot.selection.active"));
                sVGPlot.addCSSClassOrLogError(cSSClass);
            }
        }
    }

    private static enum Mode {
        REPLACE,
        ADD,
        INVERT;

    }
}

