/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.uncertain;

import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.uncertain.UncertainObject;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.utilities.exceptions.ObjectNotFoundException;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.colors.ColorLibrary;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.ClassStylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.StylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGHyperCube;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import org.w3c.dom.Element;

public class UncertainBoundingBoxVisualization
extends AbstractVisFactory {
    private static final String NAME = "Uncertain Bounding Boxes";

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2, projection);
    }

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        Hierarchy.Iter<ScatterPlotProjector> iter = VisualizationTree.filter(visualizerContext, object, ScatterPlotProjector.class);
        while (iter.valid()) {
            ScatterPlotProjector scatterPlotProjector = iter.get();
            Relation relation = scatterPlotProjector.getRelation();
            if (TypeUtil.UNCERTAIN_OBJECT_FIELD.isAssignableFromType(relation.getDataTypeInformation())) {
                VisualizationTask visualizationTask = new VisualizationTask(NAME, visualizerContext, scatterPlotProjector, relation, this);
                visualizationTask.level = 100;
                visualizationTask.addUpdateFlags(13);
                visualizerContext.addVis(scatterPlotProjector, visualizationTask);
            }
            iter.advance();
        }
    }

    public class Instance
    extends AbstractScatterplotVisualization {
        public static final String CSS_CLASS = "uncertainbb";
        protected final Relation<? extends UncertainObject> rel;

        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
            super(visualizationTask, visualizationPlot, d, d2, projection);
            this.addListeners();
            this.rel = visualizationTask.getRelation();
        }

        @Override
        public void fullRedraw() {
            this.setupCanvas();
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            double d = 0.25 * styleLibrary.getLineWidth("plot");
            StylingPolicy stylingPolicy = this.context.getStylingPolicy();
            ColorLibrary colorLibrary = styleLibrary.getColorSet("plot");
            if (stylingPolicy instanceof ClassStylingPolicy) {
                ClassStylingPolicy classStylingPolicy = (ClassStylingPolicy)stylingPolicy;
                for (int i = classStylingPolicy.getMinStyle(); i < classStylingPolicy.getMaxStyle(); ++i) {
                    String string = "uncertainbb_" + i;
                    String string2 = colorLibrary.getColor(i);
                    CSSClass cSSClass = new CSSClass(this, string);
                    cSSClass.setStatement("stroke-width", d);
                    cSSClass.setStatement("stroke-linecap", "round");
                    cSSClass.setStatement("stroke", string2);
                    cSSClass.setStatement("fill", string2);
                    cSSClass.setStatement("fill-opacity", 0.1);
                    this.svgp.addCSSClassOrLogError(cSSClass);
                    DBIDIter dBIDIter = classStylingPolicy.iterateClass(i);
                    while (dBIDIter.valid()) {
                        if (this.sample.getSample().contains(dBIDIter)) {
                            try {
                                UncertainObject uncertainObject = this.rel.get(dBIDIter);
                                Element element = SVGHyperCube.drawFrame(this.svgp, this.proj, uncertainObject);
                                SVGUtil.addCSSClass(element, string);
                                this.layer.appendChild(element);
                            }
                            catch (ObjectNotFoundException objectNotFoundException) {
                                // empty catch block
                            }
                        }
                        dBIDIter.advance();
                    }
                }
            } else {
                DBIDIter dBIDIter = this.sample.getSample().iter();
                while (dBIDIter.valid()) {
                    try {
                        UncertainObject uncertainObject = this.rel.get(dBIDIter);
                        Element element = SVGHyperCube.drawFrame(this.svgp, this.proj, uncertainObject);
                        SVGUtil.addCSSClass(element, CSS_CLASS);
                        int n = stylingPolicy.getColorForDBID(dBIDIter);
                        SVGUtil.setAtt(element, "style", "stroke:" + SVGUtil.colorToString(n));
                        this.layer.appendChild(element);
                    }
                    catch (ObjectNotFoundException objectNotFoundException) {
                        // empty catch block
                    }
                    dBIDIter.advance();
                }
            }
        }
    }
}

