/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.uncertain;

import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.uncertain.DiscreteUncertainObject;
import de.lmu.ifi.dbs.elki.data.uncertain.UncertainObject;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.FilteredIter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.utilities.exceptions.ObjectNotFoundException;
import de.lmu.ifi.dbs.elki.visualization.VisualizationItem;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.ClassStylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.StylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.marker.MarkerLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import java.util.Random;
import org.w3c.dom.Element;

public class UncertainSamplesVisualization
extends AbstractVisFactory {
    private static final String NAME = "Uncertain Samples";
    protected int samples = 10;

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2, projection);
    }

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        Hierarchy.Iter<ScatterPlotProjector> iter = VisualizationTree.filter(visualizerContext, object, ScatterPlotProjector.class);
        while (iter.valid()) {
            Object object2;
            ScatterPlotProjector scatterPlotProjector = iter.get();
            Relation relation = scatterPlotProjector.getRelation();
            if (TypeUtil.UNCERTAIN_OBJECT_FIELD.isAssignableFromType(relation.getDataTypeInformation())) {
                object2 = new VisualizationTask(NAME, visualizerContext, scatterPlotProjector, relation, this);
                ((VisualizationTask)object2).level = 100;
                ((VisualizationTask)object2).initDefaultVisibility(false);
                ((VisualizationTask)object2).addUpdateFlags(13);
                visualizerContext.addVis(scatterPlotProjector, (VisualizationItem)object2);
            } else {
                object2 = new FilteredIter<Relation>(visualizerContext.getHierarchy().iterParents(relation), Relation.class);
                while (object2.valid()) {
                    Relation relation2 = (Relation)object2.get();
                    if (TypeUtil.UNCERTAIN_OBJECT_FIELD.isAssignableFromType(relation2.getDataTypeInformation())) {
                        VisualizationTask visualizationTask = new VisualizationTask(NAME, visualizerContext, scatterPlotProjector, relation2, this);
                        visualizationTask.level = 100;
                        visualizationTask.initDefaultVisibility(false);
                        visualizationTask.addUpdateFlags(13);
                        visualizerContext.addVis(scatterPlotProjector, visualizationTask);
                    }
                    object2.advance();
                }
            }
            iter.advance();
        }
    }

    public class Instance
    extends AbstractScatterplotVisualization {
        public static final String CSS_CLASS = "uncertain-sample";
        protected final Relation<? extends UncertainObject> rel;
        protected final RandomFactory random;
        private static final String FILL = "fill:";

        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
            super(visualizationTask, visualizationPlot, d, d2, projection);
            this.random = RandomFactory.DEFAULT;
            this.addListeners();
            this.rel = visualizationTask.getRelation();
        }

        @Override
        public void fullRedraw() {
            this.setupCanvas();
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            StylingPolicy stylingPolicy = this.context.getStylingPolicy();
            double d = styleLibrary.getSize("plot.marker");
            double d2 = d / Math.sqrt(UncertainSamplesVisualization.this.samples);
            MarkerLibrary markerLibrary = styleLibrary.markers();
            Random random = this.random.getSingleThreadedRandom();
            if (stylingPolicy instanceof ClassStylingPolicy) {
                ClassStylingPolicy classStylingPolicy = (ClassStylingPolicy)stylingPolicy;
                for (int i = classStylingPolicy.getMinStyle(); i < classStylingPolicy.getMaxStyle(); ++i) {
                    DBIDIter dBIDIter = classStylingPolicy.iterateClass(i);
                    while (dBIDIter.valid()) {
                        if (this.sample.getSample().contains(dBIDIter)) {
                            try {
                                UncertainObject uncertainObject = this.rel.get(dBIDIter);
                                if (uncertainObject instanceof DiscreteUncertainObject) {
                                    this.drawDiscete((DiscreteUncertainObject)uncertainObject, markerLibrary, i, d);
                                } else {
                                    this.drawContinuous(uncertainObject, markerLibrary, i, d2, random);
                                }
                            }
                            catch (ObjectNotFoundException objectNotFoundException) {
                                // empty catch block
                            }
                        }
                        dBIDIter.advance();
                    }
                }
            } else {
                DBIDIter dBIDIter = this.sample.getSample().iter();
                while (dBIDIter.valid()) {
                    try {
                        int n = stylingPolicy.getColorForDBID(dBIDIter);
                        UncertainObject uncertainObject = this.rel.get(dBIDIter);
                        if (uncertainObject instanceof DiscreteUncertainObject) {
                            this.drawDiscreteDefault((DiscreteUncertainObject)uncertainObject, n, d);
                        } else {
                            this.drawContinuousDefault(uncertainObject, n, d, random);
                        }
                    }
                    catch (ObjectNotFoundException objectNotFoundException) {
                        // empty catch block
                    }
                    dBIDIter.advance();
                }
            }
        }

        private void drawDiscete(DiscreteUncertainObject discreteUncertainObject, MarkerLibrary markerLibrary, int n, double d) {
            int n2 = discreteUncertainObject.getNumberSamples();
            double d2 = d * Math.sqrt(n2);
            for (int i = 0; i < n2; ++i) {
                double[] dArray;
                DoubleVector doubleVector = discreteUncertainObject.getSample(i);
                if (doubleVector == null || (dArray = this.proj.fastProjectDataToRenderSpace(doubleVector))[0] != dArray[0] || dArray[1] != dArray[1]) continue;
                markerLibrary.useMarker(this.svgp, this.layer, dArray[0], dArray[1], n, discreteUncertainObject.getWeight(i) * d2);
            }
        }

        private void drawContinuous(UncertainObject uncertainObject, MarkerLibrary markerLibrary, int n, double d, Random random) {
            for (int i = 0; i < UncertainSamplesVisualization.this.samples; ++i) {
                double[] dArray = this.proj.fastProjectDataToRenderSpace(uncertainObject.drawSample(random));
                if (dArray[0] != dArray[0] || dArray[1] != dArray[1]) continue;
                markerLibrary.useMarker(this.svgp, this.layer, dArray[0], dArray[1], n, d);
            }
        }

        private void drawDiscreteDefault(DiscreteUncertainObject discreteUncertainObject, int n, double d) {
            int n2 = discreteUncertainObject.getNumberSamples();
            double d2 = d * Math.sqrt(n2);
            for (int i = 0; i < n2; ++i) {
                DoubleVector doubleVector = discreteUncertainObject.getSample(i);
                if (doubleVector == null) continue;
                double[] dArray = this.proj.fastProjectDataToRenderSpace(doubleVector);
                Element element = this.svgp.svgCircle(dArray[0], dArray[1], d2 * discreteUncertainObject.getWeight(i));
                SVGUtil.addCSSClass(element, CSS_CLASS);
                SVGUtil.setAtt(element, "style", FILL + SVGUtil.colorToString(n));
                this.layer.appendChild(element);
            }
        }

        private void drawContinuousDefault(UncertainObject uncertainObject, int n, double d, Random random) {
            for (int i = 0; i < UncertainSamplesVisualization.this.samples; ++i) {
                double[] dArray = this.proj.fastProjectDataToRenderSpace(uncertainObject.drawSample(random));
                Element element = this.svgp.svgCircle(dArray[0], dArray[1], d);
                SVGUtil.addCSSClass(element, CSS_CLASS);
                SVGUtil.setAtt(element, "style", FILL + SVGUtil.colorToString(n));
                this.layer.appendChild(element);
            }
        }
    }
}

