/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.visunproj;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.scales.LinearScale;
import de.lmu.ifi.dbs.elki.result.HistogramResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.colors.ColorLibrary;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClassManager;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPath;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGSimpleLinearAxis;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.StaticVisualizationInstance;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import org.w3c.dom.Element;

public class HistogramVisualization
extends AbstractVisFactory {
    private static final String NAME = "Histogram";
    private static final String SERIESID = "series";

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        VisualizerContext visualizerContext = visualizationTask.getContext();
        HistogramResult histogramResult = (HistogramResult)visualizationTask.getResult();
        StyleLibrary styleLibrary = visualizerContext.getStyleLibrary();
        double d3 = 100.0 * d2 / d;
        double d4 = styleLibrary.getSize("margin");
        Element element = SVGUtil.svgElement(visualizationPlot.getDocument(), "g");
        String string = SVGUtil.makeMarginTransform(d, d2, 100.0, d3, d4);
        SVGUtil.setAtt(element, "transform", string);
        int n = -1;
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        DoubleMinMax doubleMinMax2 = new DoubleMinMax();
        for (NumberVector numberVector : histogramResult) {
            doubleMinMax.put(numberVector.doubleValue(0));
            if (n < 0) {
                n = numberVector.getDimensionality();
            } else assert (n == numberVector.getDimensionality());
            for (int i = 1; i < n; ++i) {
                doubleMinMax2.put(numberVector.doubleValue(i));
            }
        }
        doubleMinMax2.put(0.0);
        --n;
        int n2 = histogramResult.size();
        double d5 = doubleMinMax.getMax() - doubleMinMax.getMin();
        double d6 = d5 / (double)(n2 - 1);
        LinearScale linearScale = new LinearScale(doubleMinMax.getMin() - d6 * 0.49999, doubleMinMax.getMax() + d6 * 0.49999);
        LinearScale linearScale2 = new LinearScale(doubleMinMax2.getMin(), doubleMinMax2.getMax());
        SVGPath[] sVGPathArray = new SVGPath[n];
        for (int i = 0; i < n; ++i) {
            sVGPathArray[i] = new SVGPath(100.0 * linearScale.getScaled(doubleMinMax.getMin() - d6 * 0.5), d3);
        }
        for (NumberVector numberVector : histogramResult) {
            for (int i = 0; i < n; ++i) {
                sVGPathArray[i].lineTo(100.0 * linearScale.getScaled(numberVector.doubleValue(0) - d6 * 0.5), d3 * (1.0 - linearScale2.getScaled(numberVector.doubleValue(i + 1))));
                sVGPathArray[i].lineTo(100.0 * linearScale.getScaled(numberVector.doubleValue(0) + d6 * 0.5), d3 * (1.0 - linearScale2.getScaled(numberVector.doubleValue(i + 1))));
            }
        }
        for (int i = 0; i < n; ++i) {
            sVGPathArray[i].lineTo(100.0 * linearScale.getScaled(doubleMinMax.getMax() + d6 * 0.5), d3);
        }
        try {
            SVGSimpleLinearAxis.drawAxis(visualizationPlot, element, linearScale2, 0.0, d3, 0.0, 0.0, SVGSimpleLinearAxis.LabelStyle.LEFTHAND, styleLibrary);
            SVGSimpleLinearAxis.drawAxis(visualizationPlot, element, linearScale, 0.0, d3, 100.0, d3, SVGSimpleLinearAxis.LabelStyle.RIGHTHAND, styleLibrary);
        }
        catch (CSSClassManager.CSSNamingConflict cSSNamingConflict) {
            LoggingUtil.exception(cSSNamingConflict);
        }
        ColorLibrary colorLibrary = styleLibrary.getColorSet("plot");
        for (int i = 0; i < n; ++i) {
            CSSClass cSSClass = new CSSClass(this, "series_" + i);
            cSSClass.setStatement("fill", "none");
            cSSClass.setStatement("stroke", colorLibrary.getColor(i));
            cSSClass.setStatement("stroke-width", styleLibrary.getLineWidth("plot"));
            visualizationPlot.addCSSClassOrLogError(cSSClass);
            Element element2 = sVGPathArray[i].makeElement(visualizationPlot);
            element2.setAttribute("class", cSSClass.getName());
            element.appendChild(element2);
        }
        return new StaticVisualizationInstance(visualizationTask, visualizationPlot, d, d2, element);
    }

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        Hierarchy.Iter<HistogramResult> iter = VisualizationTree.filterResults(visualizerContext, object, HistogramResult.class);
        while (iter.valid()) {
            HistogramResult histogramResult = iter.get();
            VisualizationTask visualizationTask = new VisualizationTask(NAME, visualizerContext, histogramResult, null, this);
            visualizationTask.reqwidth = 2.0;
            visualizationTask.reqheight = 1.0;
            visualizationTask.level = 200;
            visualizerContext.addVis(histogramResult, visualizationTask);
            iter.advance();
        }
    }

    @Override
    public boolean allowThumbnails(VisualizationTask visualizationTask) {
        return false;
    }
}

