/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.visunproj;

import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.StaticVisualizationInstance;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import org.w3c.dom.Element;

public class LabelVisualization
extends AbstractVisFactory {
    private String label = "undefined";
    private boolean rotated = false;

    public LabelVisualization() {
    }

    public LabelVisualization(String string) {
        this(string, false);
    }

    public LabelVisualization(String string, boolean bl) {
        this.label = string;
        this.rotated = bl;
    }

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
    }

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        Element element;
        VisualizerContext visualizerContext = visualizationTask.getContext();
        CSSClass cSSClass = new CSSClass(visualizationPlot, "unmanaged");
        StyleLibrary styleLibrary = visualizerContext.getStyleLibrary();
        double d3 = styleLibrary.getTextSize("overview.labels") / 100.0;
        cSSClass.setStatement("font-size", SVGUtil.fmt(d3));
        cSSClass.setStatement("fill", styleLibrary.getTextColor("overview.labels"));
        cSSClass.setStatement("font-family", styleLibrary.getFontFamily("overview.labels"));
        if (!this.rotated) {
            element = visualizationPlot.svgText(d * 0.5, d2 * 0.5 + 0.35 * d3, this.label);
            SVGUtil.setAtt(element, "style", cSSClass.inlineCSS());
            SVGUtil.setAtt(element, "text-anchor", "middle");
        } else {
            element = visualizationPlot.svgText(d2 * -0.5, d * 0.5 + 0.35 * d3, this.label);
            SVGUtil.setAtt(element, "style", cSSClass.inlineCSS());
            SVGUtil.setAtt(element, "text-anchor", "middle");
            SVGUtil.setAtt(element, "transform", "rotate(-90)");
        }
        return new StaticVisualizationInstance(visualizationTask, visualizationPlot, d, d2, element);
    }

    @Override
    public boolean allowThumbnails(VisualizationTask visualizationTask) {
        return false;
    }
}

