/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource;

import de.lmu.ifi.dbs.elki.datasource.DatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleStreamSource;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.filter.ObjectFilter;
import de.lmu.ifi.dbs.elki.datasource.filter.StreamFilter;
import de.lmu.ifi.dbs.elki.datasource.parser.Parser;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectListParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.List;

public abstract class AbstractDatabaseConnection
implements DatabaseConnection {
    public static final String LABEL_CONCATENATION = " ";
    protected List<ObjectFilter> filters;

    protected AbstractDatabaseConnection(List<ObjectFilter> list) {
        this.filters = list;
    }

    protected MultipleObjectsBundle invokeBundleFilters(MultipleObjectsBundle multipleObjectsBundle) {
        if (this.filters == null) {
            return multipleObjectsBundle;
        }
        BundleStreamSource bundleStreamSource = null;
        for (ObjectFilter objectFilter : this.filters) {
            if (objectFilter instanceof StreamFilter) {
                StreamFilter streamFilter = (StreamFilter)objectFilter;
                bundleStreamSource = streamFilter.init(bundleStreamSource != null ? bundleStreamSource : multipleObjectsBundle.asStream());
                multipleObjectsBundle = null;
                continue;
            }
            multipleObjectsBundle = objectFilter.filter(multipleObjectsBundle != null ? multipleObjectsBundle : bundleStreamSource.asMultipleObjectsBundle());
            bundleStreamSource = null;
        }
        return multipleObjectsBundle != null ? multipleObjectsBundle : bundleStreamSource.asMultipleObjectsBundle();
    }

    protected BundleStreamSource invokeStreamFilters(BundleStreamSource bundleStreamSource) {
        if (this.filters == null) {
            return bundleStreamSource;
        }
        MultipleObjectsBundle multipleObjectsBundle = null;
        for (ObjectFilter objectFilter : this.filters) {
            if (objectFilter instanceof StreamFilter) {
                bundleStreamSource = ((StreamFilter)objectFilter).init(bundleStreamSource != null ? bundleStreamSource : multipleObjectsBundle.asStream());
                multipleObjectsBundle = null;
                continue;
            }
            multipleObjectsBundle = objectFilter.filter(multipleObjectsBundle != null ? multipleObjectsBundle : bundleStreamSource.asMultipleObjectsBundle());
            bundleStreamSource = null;
        }
        return bundleStreamSource != null ? bundleStreamSource : multipleObjectsBundle.asStream();
    }

    protected abstract Logging getLogger();

    public static abstract class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID FILTERS_ID = new OptionID("dbc.filter", "The filters to apply to the input data.");
        public static final OptionID PARSER_ID = new OptionID("dbc.parser", "Parser to provide the database.");
        protected List<ObjectFilter> filters;
        protected Parser parser = null;

        protected void configFilters(Parameterization parameterization) {
            ObjectListParameter objectListParameter = new ObjectListParameter(FILTERS_ID, ObjectFilter.class, true);
            if (parameterization.grab(objectListParameter)) {
                this.filters = objectListParameter.instantiateClasses(parameterization);
            }
        }

        protected void configParser(Parameterization parameterization, Class<?> clazz, Class<?> clazz2) {
            ObjectParameter objectParameter = new ObjectParameter(PARSER_ID, clazz, clazz2);
            if (parameterization.grab(objectParameter)) {
                this.parser = (Parser)objectParameter.instantiateClass(parameterization);
            }
        }
    }
}

