/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkapp;

import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class PolynomialApproximation
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private double[] b;

    public PolynomialApproximation() {
    }

    public PolynomialApproximation(double[] dArray) {
        this.b = dArray;
    }

    public double getB(int n) {
        return this.b[n];
    }

    public double[] getCoefficients() {
        double[] dArray = new double[this.b.length];
        System.arraycopy(this.b, 0, dArray, 0, this.b.length);
        return dArray;
    }

    public int getPolynomialOrder() {
        return this.b.length;
    }

    public double getValueAt(int n) {
        double d = 0.0;
        double d2 = Math.log(n);
        double d3 = 1.0;
        for (int i = 0; i < this.b.length; ++i) {
            d += this.b[i] * d3;
            d3 *= d2;
        }
        return d;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.b.length);
        for (double d : this.b) {
            objectOutput.writeDouble(d);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        this.b = new double[objectInput.readInt()];
        for (int i = 0; i < this.b.length; ++i) {
            this.b[i] = objectInput.readDouble();
        }
    }

    public String toString() {
        return FormatUtil.format(this.b, FormatUtil.NF4);
    }
}

