/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.ChiSquaredDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.GammaDistribution;
import de.lmu.ifi.dbs.elki.utilities.exceptions.NotImplementedException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.Random;

public class ChiDistribution
extends AbstractDistribution {
    private double dof;
    private ChiSquaredDistribution chisq;

    public ChiDistribution(double d) {
        this(d, (Random)null);
    }

    public ChiDistribution(double d, Random random) {
        super(random);
        this.dof = d;
        this.chisq = new ChiSquaredDistribution(d, random);
    }

    public ChiDistribution(double d, RandomFactory randomFactory) {
        super(randomFactory);
        this.dof = d;
        this.chisq = new ChiSquaredDistribution(d, randomFactory);
    }

    @Override
    public double nextRandom() {
        return Math.sqrt(this.chisq.nextRandom());
    }

    @Override
    public double pdf(double d) {
        return ChiDistribution.pdf(d, this.dof);
    }

    public static double pdf(double d, double d2) {
        if (d < 0.0) {
            return 0.0;
        }
        return Math.sqrt(ChiSquaredDistribution.pdf(d, d2));
    }

    @Override
    public double cdf(double d) {
        return ChiDistribution.cdf(d, this.dof);
    }

    public static double cdf(double d, double d2) {
        return GammaDistribution.regularizedGammaP(d2 * 0.5, d * d * 0.5);
    }

    @Override
    public double quantile(double d) {
        throw new NotImplementedException("Not yet supported.");
    }

    @Override
    public String toString() {
        return "ChiDistribution(dof=" + this.dof + ")";
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        double dof;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter = new DoubleParameter(ChiSquaredDistribution.Parameterizer.DOF_ID);
            if (parameterization.grab(doubleParameter)) {
                this.dof = doubleParameter.doubleValue();
            }
        }

        @Override
        protected ChiDistribution makeInstance() {
            return new ChiDistribution(this.dof, this.rnd);
        }
    }
}

