/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.visunproj;

import de.lmu.ifi.dbs.elki.evaluation.outlier.OutlierPrecisionRecallCurve;
import de.lmu.ifi.dbs.elki.evaluation.outlier.OutlierROCCurve;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.math.geometry.XYCurve;
import de.lmu.ifi.dbs.elki.math.scales.LinearScale;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClassManager;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPath;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGSimpleLinearAxis;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.StaticVisualizationInstance;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XYCurveVisualization
extends AbstractVisFactory {
    private static final String NAME = "XYCurve";
    private static final String SERIESID = "series";
    private static final String CSS_AXIS_LABEL = "xy-axis-label";

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        Element element;
        VisualizerContext visualizerContext = visualizationTask.getContext();
        XYCurve xYCurve = (XYCurve)visualizationTask.getResult();
        this.setupCSS(visualizerContext, visualizationPlot);
        StyleLibrary styleLibrary = visualizerContext.getStyleLibrary();
        double d3 = 100.0 * d2 / d;
        double d4 = styleLibrary.getSize("margin");
        Element element2 = SVGUtil.svgElement(visualizationPlot.getDocument(), "g");
        String string = SVGUtil.makeMarginTransform(d, d2, 100.0, d3, d4);
        SVGUtil.setAtt(element2, "transform", string);
        LinearScale linearScale = new LinearScale(xYCurve.getMinx(), xYCurve.getMaxx());
        LinearScale linearScale2 = new LinearScale(xYCurve.getMiny(), xYCurve.getMaxy());
        SVGPath sVGPath = new SVGPath();
        Object object = xYCurve.iterator();
        while (((XYCurve.Itr)object).valid()) {
            double d5 = linearScale.getScaled(((XYCurve.Itr)object).getX());
            double d6 = 1.0 - linearScale2.getScaled(((XYCurve.Itr)object).getY());
            sVGPath.drawTo(100.0 * d5, d3 * d6);
            ((XYCurve.Itr)object).advance();
        }
        object = sVGPath.makeElement(visualizationPlot);
        object.setAttribute("class", SERIESID);
        try {
            SVGSimpleLinearAxis.drawAxis(visualizationPlot, element2, linearScale2, 0.0, d3, 0.0, 0.0, SVGSimpleLinearAxis.LabelStyle.LEFTHAND, styleLibrary);
            SVGSimpleLinearAxis.drawAxis(visualizationPlot, element2, linearScale, 0.0, d3, 100.0, d3, SVGSimpleLinearAxis.LabelStyle.RIGHTHAND, styleLibrary);
        }
        catch (CSSClassManager.CSSNamingConflict cSSNamingConflict) {
            LoggingUtil.exception(cSSNamingConflict);
        }
        Element element3 = visualizationPlot.svgText(50.0, d3 + d4 * 0.9, xYCurve.getLabelx());
        SVGUtil.setCSSClass(element3, CSS_AXIS_LABEL);
        element2.appendChild(element3);
        Element element4 = visualizationPlot.svgText(d4 * -0.8, d3 * 0.5, xYCurve.getLabely());
        SVGUtil.setCSSClass(element4, CSS_AXIS_LABEL);
        SVGUtil.setAtt(element4, "transform", "rotate(-90," + FormatUtil.NF6.format(d4 * -0.8) + "," + FormatUtil.NF6.format(d3 * 0.5) + ")");
        element2.appendChild(element4);
        if (xYCurve instanceof OutlierROCCurve.ROCResult) {
            double d7 = ((OutlierROCCurve.ROCResult)xYCurve).getAUC();
            String string2 = "ROCAUC: " + FormatUtil.NF.format(d7);
            if (d7 <= 0.5) {
                element = visualizationPlot.svgText(50.0, d3 * 0.1, string2);
                SVGUtil.setCSSClass(element, CSS_AXIS_LABEL);
                element2.appendChild(element);
            } else {
                element = visualizationPlot.svgText(50.0, d3 * 0.95, string2);
                SVGUtil.setCSSClass(element, CSS_AXIS_LABEL);
                element2.appendChild(element);
            }
        }
        if (xYCurve instanceof OutlierPrecisionRecallCurve.PRCurve) {
            double d8 = ((OutlierPrecisionRecallCurve.PRCurve)xYCurve).getAUC();
            String string3 = "PR-AUC: " + FormatUtil.NF.format(d8);
            if (d8 <= 0.5) {
                element = visualizationPlot.svgText(50.0, d3 * 0.1, string3);
                SVGUtil.setCSSClass(element, CSS_AXIS_LABEL);
                element2.appendChild(element);
            } else {
                element = visualizationPlot.svgText(50.0, d3 * 0.95, string3);
                SVGUtil.setCSSClass(element, CSS_AXIS_LABEL);
                element2.appendChild(element);
            }
        }
        element2.appendChild((Node)object);
        return new StaticVisualizationInstance(visualizationTask, visualizationPlot, d, d2, element2);
    }

    private void setupCSS(VisualizerContext visualizerContext, SVGPlot sVGPlot) {
        StyleLibrary styleLibrary = visualizerContext.getStyleLibrary();
        CSSClass cSSClass = new CSSClass(this, SERIESID);
        cSSClass.setStatement("fill", "none");
        styleLibrary.lines().formatCSSClass(cSSClass, 0, styleLibrary.getLineWidth("xycurve"), new Object[0]);
        sVGPlot.addCSSClassOrLogError(cSSClass);
        CSSClass cSSClass2 = new CSSClass(this, CSS_AXIS_LABEL);
        cSSClass2.setStatement("fill", styleLibrary.getTextColor("xycurve"));
        cSSClass2.setStatement("font-family", styleLibrary.getFontFamily("xycurve"));
        cSSClass2.setStatement("font-size", styleLibrary.getTextSize("xycurve"));
        cSSClass2.setStatement("text-anchor", "middle");
        sVGPlot.addCSSClassOrLogError(cSSClass2);
        sVGPlot.updateStyleElement();
    }

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        Hierarchy.Iter<XYCurve> iter = VisualizationTree.filterResults(visualizerContext, object, XYCurve.class);
        while (iter.valid()) {
            XYCurve xYCurve = iter.get();
            VisualizationTask visualizationTask = new VisualizationTask(NAME, visualizerContext, xYCurve, null, this);
            visualizationTask.reqwidth = 1.0;
            visualizationTask.reqheight = 1.0;
            visualizationTask.level = 200;
            visualizerContext.addVis(xYCurve, visualizationTask);
            iter.advance();
        }
    }

    @Override
    public boolean allowThumbnails(VisualizationTask visualizationTask) {
        return false;
    }
}

