/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.visunproj;

import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.math.geometry.XYPlot;
import de.lmu.ifi.dbs.elki.math.scales.LinearScale;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClassManager;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPath;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGSimpleLinearAxis;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.StaticVisualizationInstance;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XYPlotVisualization
extends AbstractVisFactory {
    private static final String NAME = "XYPlot";
    private static final String SERIESID = "series_";
    private static final String CSS_AXIS_LABEL = "xy-axis-label";

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        Object object2;
        VisualizerContext visualizerContext = visualizationTask.getContext();
        XYPlot xYPlot = (XYPlot)visualizationTask.getResult();
        this.setupCSS(visualizerContext, visualizationPlot, xYPlot);
        StyleLibrary styleLibrary = visualizerContext.getStyleLibrary();
        double d3 = 100.0 * d2 / d;
        double d4 = styleLibrary.getSize("margin");
        Element element = SVGUtil.svgElement(visualizationPlot.getDocument(), "g");
        String string = SVGUtil.makeMarginTransform(d, d2, 100.0, d3, d4);
        SVGUtil.setAtt(element, "transform", string);
        LinearScale linearScale = new LinearScale(xYPlot.getMinx(), xYPlot.getMaxx());
        LinearScale linearScale2 = new LinearScale(xYPlot.getMiny(), xYPlot.getMaxy());
        for (Object object2 : xYPlot) {
            SVGPath sVGPath = new SVGPath();
            Object object3 = ((XYPlot.Curve)object2).iterator();
            while (((XYPlot.Curve.Itr)object3).valid()) {
                double d5 = linearScale.getScaled(((XYPlot.Curve.Itr)object3).getX());
                double d6 = 1.0 - linearScale2.getScaled(((XYPlot.Curve.Itr)object3).getY());
                sVGPath.drawTo(100.0 * d5, d3 * d6);
                ((XYPlot.Curve.Itr)object3).advance();
            }
            object3 = sVGPath.makeElement(visualizationPlot);
            object3.setAttribute("class", SERIESID + ((XYPlot.Curve)object2).getColor());
            element.appendChild((Node)object3);
        }
        try {
            SVGSimpleLinearAxis.drawAxis(visualizationPlot, element, linearScale2, 0.0, d3, 0.0, 0.0, SVGSimpleLinearAxis.LabelStyle.LEFTHAND, styleLibrary);
            SVGSimpleLinearAxis.drawAxis(visualizationPlot, element, linearScale, 0.0, d3, 100.0, d3, SVGSimpleLinearAxis.LabelStyle.RIGHTHAND, styleLibrary);
        }
        catch (CSSClassManager.CSSNamingConflict cSSNamingConflict) {
            LoggingUtil.exception(cSSNamingConflict);
        }
        Element element2 = visualizationPlot.svgText(50.0, d3 + d4 * 0.9, xYPlot.getLabelx());
        SVGUtil.setCSSClass(element2, CSS_AXIS_LABEL);
        element.appendChild(element2);
        object2 = visualizationPlot.svgText(d4 * -0.8, d3 * 0.5, xYPlot.getLabely());
        SVGUtil.setCSSClass((Element)object2, CSS_AXIS_LABEL);
        SVGUtil.setAtt((Element)object2, "transform", "rotate(-90," + FormatUtil.NF6.format(d4 * -0.8) + "," + FormatUtil.NF6.format(d3 * 0.5) + ")");
        element.appendChild((Node)object2);
        return new StaticVisualizationInstance(visualizationTask, visualizationPlot, d, d2, element);
    }

    private void setupCSS(VisualizerContext visualizerContext, SVGPlot sVGPlot, XYPlot xYPlot) {
        StyleLibrary styleLibrary = visualizerContext.getStyleLibrary();
        for (XYPlot.Curve curve : xYPlot) {
            CSSClass cSSClass = new CSSClass(this, SERIESID + curve.getColor());
            cSSClass.setStatement("fill", "none");
            styleLibrary.lines().formatCSSClass(cSSClass, curve.getColor(), styleLibrary.getLineWidth("xycurve"), new Object[0]);
            sVGPlot.addCSSClassOrLogError(cSSClass);
        }
        CSSClass cSSClass = new CSSClass(this, CSS_AXIS_LABEL);
        cSSClass.setStatement("fill", styleLibrary.getTextColor("xycurve"));
        cSSClass.setStatement("font-family", styleLibrary.getFontFamily("xycurve"));
        cSSClass.setStatement("font-size", styleLibrary.getTextSize("xycurve"));
        cSSClass.setStatement("text-anchor", "middle");
        sVGPlot.addCSSClassOrLogError(cSSClass);
        sVGPlot.updateStyleElement();
    }

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        Hierarchy.Iter<XYPlot> iter = VisualizationTree.filterResults(visualizerContext, object, XYPlot.class);
        while (iter.valid()) {
            XYPlot xYPlot = iter.get();
            VisualizationTask visualizationTask = new VisualizationTask(NAME, visualizerContext, xYPlot, null, this);
            visualizationTask.reqwidth = 1.0;
            visualizationTask.reqheight = 1.0;
            visualizationTask.level = 200;
            visualizerContext.addVis(xYPlot, visualizationTask);
            iter.advance();
        }
    }

    @Override
    public boolean allowThumbnails(VisualizationTask visualizationTask) {
        return false;
    }
}

