/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.intrinsic;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.IntrinsicDimensionalityEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.MOMEstimator;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierScoreMeta;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

public class IntrinsicDimensionalityOutlier<O>
extends AbstractDistanceBasedAlgorithm<O, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(IntrinsicDimensionalityOutlier.class);
    protected int k;
    protected IntrinsicDimensionalityEstimator estimator;

    public IntrinsicDimensionalityOutlier(DistanceFunction<? super O> distanceFunction, int n, IntrinsicDimensionalityEstimator intrinsicDimensionalityEstimator) {
        super(distanceFunction);
        this.k = n;
        this.estimator = intrinsicDimensionalityEstimator;
    }

    public OutlierResult run(Database database, Relation<O> relation) {
        Object object;
        DistanceQuery<O> distanceQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        KNNQuery<O> kNNQuery = database.getKNNQuery(distanceQuery, this.k + 1);
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("kNN distance for objects", relation.size(), LOG) : null;
        double[] dArray = new double[this.k + 10];
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 4);
        Object object2 = relation.iterDBIDs();
        while (object2.valid()) {
            int n;
            object = kNNQuery.getKNNForDBID((DBIDRef)object2, this.k + 1);
            while (object.getKNNDistance() == 0.0) {
                n = object.size() + this.k;
                if (n >= relation.size()) {
                    throw new AbortException("Too many duplicates!");
                }
                object = kNNQuery.getKNNForDBID((DBIDRef)object2, n);
                if (object.size() >= n) continue;
                break;
            }
            if (dArray.length < object.size()) {
                dArray = new double[object.size()];
            }
            n = 0;
            DoubleDBIDListIter doubleDBIDListIter = object.iter();
            while (doubleDBIDListIter.valid()) {
                if (doubleDBIDListIter.doubleValue() != 0.0 && !DBIDUtil.equal((DBIDRef)object2, doubleDBIDListIter)) {
                    dArray[n++] = doubleDBIDListIter.doubleValue();
                }
                doubleDBIDListIter.advance();
            }
            double d = 0.0;
            try {
                d = n > 1 ? this.estimator.estimate(dArray, n) : 0.0;
            }
            catch (ArithmeticException arithmeticException) {
                d = 0.0;
            }
            writableDoubleDataStore.putDouble((DBIDRef)object2, d);
            doubleMinMax.put(d);
            LOG.incrementProcessed(finiteProgress);
            object2.advance();
        }
        LOG.ensureCompleted(finiteProgress);
        object2 = new MaterializedDoubleRelation("Intrinsic dimensionality", "id-score", writableDoubleDataStore, relation.getDBIDs());
        object = new BasicOutlierScoreMeta(doubleMinMax.getMin(), doubleMinMax.getMax(), 0.0, Double.POSITIVE_INFINITY, 0.0);
        return new OutlierResult((OutlierScoreMeta)object, (DoubleRelation)object2);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID K_ID = new OptionID("id.k", "Number of nearest neighbors to use for ID estimation (usually 20-100).");
        public static final OptionID ESTIMATOR_ID = new OptionID("id.estimator", "Class to estimate ID from distance distribution.");
        protected int k;
        protected IntrinsicDimensionalityEstimator estimator;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            ObjectParameter objectParameter;
            super.makeOptions(parameterization);
            IntParameter intParameter = (IntParameter)new IntParameter(K_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.k = intParameter.intValue();
            }
            if (parameterization.grab(objectParameter = new ObjectParameter(ESTIMATOR_ID, (Class<?>)IntrinsicDimensionalityEstimator.class, MOMEstimator.class))) {
                this.estimator = (IntrinsicDimensionalityEstimator)objectParameter.instantiateClass(parameterization);
            }
        }

        @Override
        protected IntrinsicDimensionalityOutlier<O> makeInstance() {
            return new IntrinsicDimensionalityOutlier(this.distanceFunction, this.k, this.estimator);
        }
    }
}

