/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.application.internal;

import de.lmu.ifi.dbs.elki.KDDTask;
import de.lmu.ifi.dbs.elki.application.AbstractApplication;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.LoggingConfiguration;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.ELKIServiceRegistry;
import de.lmu.ifi.dbs.elki.utilities.ELKIServiceScanner;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.Parameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.TrackParameters;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.TrackedParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.UnParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ClassListParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ClassParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Parameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import de.lmu.ifi.dbs.elki.utilities.pairs.Pair;
import de.lmu.ifi.dbs.elki.utilities.xml.HTMLUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DocumentParameters {
    private static final Logging LOG = Logging.getLogger(DocumentParameters.class);
    private static final String HEADER_PARAMETER_FOR = "Parameter for: ";
    private static final String HEADER_DEFAULT_VALUE = "Default: ";
    private static final String NO_DEFAULT_VALUE = "No default value.";
    private static final String HEADER_CLASS_RESTRICTION = "Class Restriction: ";
    private static final String HEADER_CLASS_RESTRICTION_IMPLEMENTING = "implements ";
    private static final String HEADER_CLASS_RESTRICTION_EXTENDING = "extends ";
    private static final String NO_CLASS_RESTRICTION = "No class restriction.";
    private static final String CSSFILE = "stylesheet.css";
    private static final String MODIFICATION_WARNING = "WARNING: THIS DOCUMENT IS AUTOMATICALLY GENERATED. MODIFICATIONS MAY GET LOST.";
    private static final String HEADER_KNOWN_IMPLEMENTATIONS = "Known implementations: ";
    private static final boolean FULL_WIKI_OUTPUT = false;

    public static void main(String[] stringArray) {
        FileOutputStream fileOutputStream;
        LoggingConfiguration.setVerbose(Logging.Level.VERBOSE);
        if (stringArray.length != 2 && stringArray.length != 4) {
            LOG.warning("I need exactly two or four file names to operate!");
            System.exit(1);
        }
        if (!stringArray[0].endsWith(".html")) {
            LOG.warning("First file name doesn't end with .html!");
            System.exit(1);
        }
        if (!stringArray[1].endsWith(".html")) {
            LOG.warning("Second file name doesn't end with .html!");
            System.exit(1);
        }
        if (stringArray.length > 2 && !stringArray[2].endsWith(".trac")) {
            LOG.warning("Third file name doesn't end with .trac!");
            System.exit(1);
        }
        if (stringArray.length > 3 && !stringArray[3].endsWith(".trac")) {
            LOG.warning("Fourth file name doesn't end with .trac!");
            System.exit(1);
        }
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        File file3 = stringArray.length >= 3 ? new File(stringArray[2]) : null;
        File file4 = stringArray.length >= 4 ? new File(stringArray[3]) : null;
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        try {
            DocumentParameters.buildParameterIndex(hashMap, hashMap2);
        }
        catch (Exception exception) {
            LOG.exception(exception);
            System.exit(1);
        }
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOG.exception("Can't create output stream!", fileNotFoundException);
            throw new RuntimeException(fileNotFoundException);
        }
        FilterOutputStream filterOutputStream = new BufferedOutputStream(fileOutputStream);
        Document document = DocumentParameters.makeByClassOverviewHTML(hashMap);
        try {
            HTMLUtil.writeXHTML(document, filterOutputStream);
            ((OutputStream)filterOutputStream).flush();
            ((OutputStream)filterOutputStream).close();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            LOG.exception("IO Exception writing output.", iOException);
            throw new RuntimeException(iOException);
        }
        if (file3 != null) {
            try {
                fileOutputStream = new FileOutputStream(file3);
            }
            catch (FileNotFoundException fileNotFoundException) {
                LOG.exception("Can't create output stream!", fileNotFoundException);
                throw new RuntimeException(fileNotFoundException);
            }
            try {
                filterOutputStream = new PrintStream((OutputStream)new BufferedOutputStream(fileOutputStream), false, "UTF-8");
                DocumentParameters.makeByClassOverviewWiki(hashMap, new WikiStream((PrintStream)filterOutputStream));
                ((PrintStream)filterOutputStream).flush();
                ((PrintStream)filterOutputStream).close();
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                LOG.exception("IO Exception writing output.", iOException);
                throw new RuntimeException(iOException);
            }
        }
        try {
            fileOutputStream = new FileOutputStream(file2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOG.exception("Can't create output stream!", fileNotFoundException);
            throw new RuntimeException(fileNotFoundException);
        }
        filterOutputStream = new BufferedOutputStream(fileOutputStream);
        document = DocumentParameters.makeByOptOverviewHTML(hashMap2);
        try {
            HTMLUtil.writeXHTML(document, fileOutputStream);
            ((OutputStream)filterOutputStream).flush();
            ((OutputStream)filterOutputStream).close();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            LOG.exception("IO Exception writing output.", iOException);
            throw new RuntimeException(iOException);
        }
        if (file4 != null) {
            try {
                fileOutputStream = new FileOutputStream(file4);
            }
            catch (FileNotFoundException fileNotFoundException) {
                LOG.exception("Can't create output stream!", fileNotFoundException);
                throw new RuntimeException(fileNotFoundException);
            }
            try {
                filterOutputStream = new PrintStream(new BufferedOutputStream(fileOutputStream));
                DocumentParameters.makeByOptOverviewWiki(hashMap2, new WikiStream((PrintStream)filterOutputStream));
                ((PrintStream)filterOutputStream).flush();
                ((PrintStream)filterOutputStream).close();
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                LOG.exception("IO Exception writing output.", iOException);
                throw new RuntimeException(iOException);
            }
        }
        System.exit(0);
    }

    private static void buildParameterIndex(Map<Class<?>, List<Parameter<?>>> map, Map<OptionID, List<Pair<Parameter<?>, Class<?>>>> map2) {
        List<Pair<Parameter<?>, Class<?>>> list;
        Object object;
        Class<Object> clazz;
        ArrayList arrayList = new ArrayList();
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        List<Class<?>> list2 = ELKIServiceRegistry.findAllImplementations(Object.class, false, true);
        Collections.sort(list2, new ELKIServiceScanner.ClassSorter());
        for (final Class<?> object2 : list2) {
            if (object2.getCanonicalName() == null || AbstractApplication.class.isAssignableFrom(object2)) continue;
            clazz = new UnParameterization();
            object = new TrackParameters((Parameterization)((Object)clazz), object2);
            list = new FutureTask<Object>(new Runnable((TrackParameters)object, arrayList){
                final /* synthetic */ TrackParameters val$track;
                final /* synthetic */ ArrayList val$options;
                {
                    this.val$track = trackParameters;
                    this.val$options = arrayList;
                }

                @Override
                public void run() {
                    Parameterizer parameterizer = ClassGenericsUtil.getParameterizer(object2);
                    if (parameterizer != null) {
                        parameterizer.configure(this.val$track);
                    } else {
                        try {
                            ClassGenericsUtil.tryInstantiate(Object.class, object2, this.val$track);
                        }
                        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            if (invocationTargetException.getCause() instanceof RuntimeException) {
                                throw (RuntimeException)invocationTargetException.getCause();
                            }
                            if (invocationTargetException.getCause() instanceof Error) {
                                throw (Error)invocationTargetException.getCause();
                            }
                            throw new RuntimeException(invocationTargetException.getCause());
                        }
                        catch (RuntimeException runtimeException) {
                            throw runtimeException;
                        }
                        catch (Error | Exception throwable) {
                            throw new RuntimeException(throwable);
                        }
                    }
                    for (TrackedParameter trackedParameter : this.val$track.getAllParameters()) {
                        if (trackedParameter.getOwner() == null) {
                            LOG.warning("No owner for parameter " + trackedParameter.getParameter() + " expected a " + object2.getName());
                            continue;
                        }
                        this.val$options.add(trackedParameter);
                    }
                }
            }, null);
            executorService.submit((Runnable)((Object)list));
            try {
                ((FutureTask)((Object)list)).get(1L, TimeUnit.SECONDS);
            }
            catch (TimeoutException exception) {
                LOG.warning("Timeout on instantiating " + object2.getName());
                executorService.shutdownNow();
                throw new RuntimeException(exception);
            }
            catch (ExecutionException bl) {
                if (object2.getName().startsWith("de.lmu.ifi.dbs.elki")) {
                    LOG.warning("Error instantiating " + object2.getName(), bl.getCause());
                    continue;
                }
                LOG.warning("Error instantiating " + object2.getName());
            }
            catch (Exception exception) {
                if (object2.getName().startsWith("de.lmu.ifi.dbs.elki")) {
                    LOG.warning("Error instantiating " + object2.getName(), exception.getCause());
                    continue;
                }
                LOG.warning("Error instantiating " + object2.getName());
            }
        }
        LOG.debug("Documenting " + arrayList.size() + " parameter instances.");
        for (TrackedParameter trackedParameter : arrayList) {
            List<Object> list3;
            if (trackedParameter.getOwner() == null || trackedParameter.getParameter() == null) {
                LOG.debugFiner("Null: " + trackedParameter.getOwner() + " " + trackedParameter.getParameter());
                continue;
            }
            clazz = trackedParameter.getOwner() instanceof Class ? (Class)trackedParameter.getOwner() : trackedParameter.getOwner().getClass();
            object = trackedParameter.getParameter();
            list = map.get(clazz);
            boolean bl = false;
            if (list != null) {
                for (Parameter parameter : list) {
                    if (parameter.getOptionID() != object.getOptionID()) continue;
                    bl = true;
                    break;
                }
            }
            if (!bl) {
                list3 = map.get(clazz);
                if (list3 == null) {
                    list3 = new ArrayList<Object>();
                    map.put(clazz, list3);
                }
                list3.add((Pair<Parameter<?>, Class<?>>)object);
            }
            list = map2.get(object.getOptionID());
            bl = false;
            if (list != null) {
                for (Pair pair : list) {
                    if (!((Class)pair.second).equals(clazz)) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) continue;
            list3 = map2.get(object.getOptionID());
            if (list3 == null) {
                list3 = new ArrayList();
                map2.put(object.getOptionID(), list3);
            }
            list3.add(new Pair(object, clazz));
        }
        LOG.debug("byClass: " + map.size() + " byOpt: " + map2.size());
    }

    protected static Constructor<?> getConstructor(Class<?> clazz) {
        try {
            return clazz.getConstructor(Parameterization.class);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (RuntimeException runtimeException) {
            LOG.warning("RuntimeException: ", runtimeException);
        }
        catch (Exception exception) {
        }
        catch (Error error) {
            LOG.warning("Error: ", error);
        }
        return null;
    }

    private static Document makeByClassOverviewHTML(Map<Class<?>, List<Parameter<?>>> map) {
        DocumentBuilder documentBuilder;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException);
        }
        DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
        Document document = dOMImplementation.createDocument("http://www.w3.org/1999/xhtml", "html", null);
        Element element = document.createElement("head");
        document.getDocumentElement().appendChild(element);
        Element element2 = document.createElement("body");
        document.getDocumentElement().appendChild(element2);
        Node node = document.createComment(MODIFICATION_WARNING);
        element.appendChild(node);
        Object object = document.createComment(MODIFICATION_WARNING);
        element2.appendChild((Node)object);
        node = document.createElement("meta");
        node.setAttribute("http-equiv", "Content-Type");
        node.setAttribute("content", "text/html; charset=UTF-8");
        element.appendChild(node);
        node = document.createElement("link");
        node.setAttribute("rel", "stylesheet");
        node.setAttribute("type", "text/css");
        node.setAttribute("href", CSSFILE);
        element.appendChild(node);
        node = document.createElement("title");
        node.setTextContent("Command line parameter overview.");
        element.appendChild(node);
        node = document.createElement("h1");
        node.setTextContent("ELKI command line parameter overview:");
        element2.appendChild(node);
        node = document.createElement("dl");
        element2.appendChild(node);
        object = new ArrayList(map.keySet());
        Collections.sort(object, new ELKIServiceScanner.ClassSorter());
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            Element element3 = document.createElement("dt");
            Element element4 = document.createElement("a");
            element4.setAttribute("name", clazz.getName());
            element3.appendChild(element4);
            element4 = document.createElement("a");
            element4.setAttribute("href", DocumentParameters.linkForClassName(clazz.getName()));
            element4.setTextContent(clazz.getName());
            element3.appendChild(element4);
            node.appendChild(element3);
            element4 = document.createElement("dd");
            node.appendChild(element4);
            Element element5 = document.createElement("dl");
            element4.appendChild(element5);
            for (Parameter<?> parameter : map.get(clazz)) {
                Class clazz2;
                Element element6 = document.createElement("dt");
                Element element7 = document.createElement("tt");
                element7.setTextContent("-" + parameter.getName() + " " + parameter.getSyntax());
                element6.appendChild(element7);
                element5.appendChild(element6);
                element7 = document.createElement("dd");
                Element element8 = document.createElement("p");
                if (parameter.getShortDescription() != null) {
                    HTMLUtil.appendMultilineText(document, element8, parameter.getShortDescription());
                }
                element7.appendChild(element8);
                if (parameter instanceof ClassParameter) {
                    DocumentParameters.appendClassRestriction(document, ((ClassParameter)parameter).getRestrictionClass(), element7);
                }
                DocumentParameters.appendDefaultValueIfSet(document, parameter, element7);
                if (parameter instanceof ClassParameter) {
                    clazz2 = ((ClassParameter)parameter).getRestrictionClass();
                    DocumentParameters.appendKnownImplementationsIfNonempty(document, clazz2, element7);
                } else if (parameter instanceof ClassListParameter) {
                    clazz2 = ((ClassListParameter)parameter).getRestrictionClass();
                    DocumentParameters.appendKnownImplementationsIfNonempty(document, clazz2, element7);
                }
                element5.appendChild(element7);
            }
        }
        return document;
    }

    private static void makeByClassOverviewWiki(Map<Class<?>, List<Parameter<?>>> map, WikiStream wikiStream) {
        ArrayList arrayList = new ArrayList(map.keySet());
        Collections.sort(arrayList, new ELKIServiceScanner.ClassSorter());
        for (Class clazz : arrayList) {
            wikiStream.indent = 0;
            wikiStream.printitem("'''");
            wikiStream.javadocLink(clazz, KDDTask.class);
            wikiStream.println("''':");
            wikiStream.indent = 1;
            wikiStream.newline = 1;
            for (Parameter<?> parameter : map.get(clazz)) {
                wikiStream.printitem("* ");
                wikiStream.print("{{{");
                wikiStream.print("-");
                wikiStream.print(parameter.getName());
                wikiStream.print(" ");
                wikiStream.print(parameter.getSyntax());
                wikiStream.println("}}}");
                if (parameter.getShortDescription() != null) {
                    DocumentParameters.appendMultilineTextWiki(wikiStream, parameter.getShortDescription());
                }
                if (parameter instanceof ClassParameter) {
                    DocumentParameters.appendClassRestrictionWiki(wikiStream, ((ClassParameter)parameter).getRestrictionClass());
                }
                if (!parameter.hasDefaultValue()) continue;
                DocumentParameters.appendDefaultValueWiki(wikiStream, parameter);
            }
        }
    }

    private static int appendMultilineTextWiki(WikiStream wikiStream, String string) {
        String[] stringArray = string.split("\n");
        for (int i = 0; i < stringArray.length; ++i) {
            wikiStream.println(stringArray[i]);
        }
        return stringArray.length;
    }

    private static Document makeByOptOverviewHTML(Map<OptionID, List<Pair<Parameter<?>, Class<?>>>> map) {
        DocumentBuilder documentBuilder;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException);
        }
        DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
        Document document = dOMImplementation.createDocument("http://www.w3.org/1999/xhtml", "html", null);
        Element element = document.createElement("head");
        document.getDocumentElement().appendChild(element);
        Element element2 = document.createElement("body");
        document.getDocumentElement().appendChild(element2);
        Node node = document.createComment(MODIFICATION_WARNING);
        element.appendChild(node);
        Object object = document.createComment(MODIFICATION_WARNING);
        element2.appendChild((Node)object);
        node = document.createElement("meta");
        node.setAttribute("http-equiv", "Content-Type");
        node.setAttribute("content", "text/html; charset=UTF-8");
        element.appendChild(node);
        node = document.createElement("link");
        node.setAttribute("rel", "stylesheet");
        node.setAttribute("type", "text/css");
        node.setAttribute("href", CSSFILE);
        element.appendChild(node);
        node = document.createElement("title");
        node.setTextContent("Command line parameter overview - by option");
        element.appendChild(node);
        node = document.createElement("h1");
        node.setTextContent("ELKI command line parameter overview:");
        element2.appendChild(node);
        node = document.createElement("dl");
        element2.appendChild(node);
        object = new SortByOption();
        ELKIServiceScanner.ClassSorter classSorter = new ELKIServiceScanner.ClassSorter();
        Comparator comparator = new Comparator<Pair<Parameter<?>, Class<?>>>((Comparator)object, classSorter){
            final /* synthetic */ Comparator val$osort;
            final /* synthetic */ Comparator val$csort;
            {
                this.val$osort = comparator;
                this.val$csort = comparator2;
            }

            @Override
            public int compare(Pair<Parameter<?>, Class<?>> pair, Pair<Parameter<?>, Class<?>> pair2) {
                int n = this.val$osort.compare(((Parameter)pair.first).getOptionID(), ((Parameter)pair2.first).getOptionID());
                return n != 0 ? n : this.val$csort.compare(pair.second, pair2.second);
            }
        };
        ArrayList<OptionID> arrayList = new ArrayList<OptionID>(map.keySet());
        Collections.sort(arrayList, object);
        for (OptionID optionID : arrayList) {
            Object object2;
            Parameter<?> parameter = map.get(optionID).get(0).getFirst();
            Element element3 = document.createElement("dt");
            Element element4 = document.createElement("a");
            element4.setAttribute("name", parameter.getName());
            element3.appendChild(element4);
            element4 = document.createElement("tt");
            element4.setTextContent("-" + parameter.getName() + " " + parameter.getSyntax());
            element3.appendChild(element4);
            node.appendChild(element3);
            element4 = document.createElement("dd");
            Class clazz = document.createElement("p");
            HTMLUtil.appendMultilineText(document, (Element)((Object)clazz), parameter.getShortDescription());
            element4.appendChild((Node)((Object)clazz));
            clazz = null;
            if (parameter instanceof ClassParameter) {
                clazz = ((ClassParameter)parameter).getRestrictionClass();
            } else if (parameter instanceof ClassListParameter) {
                clazz = ((ClassListParameter)parameter).getRestrictionClass();
            }
            if (clazz != null) {
                for (Pair<Parameter<?>, Class<?>> pair : map.get(optionID)) {
                    if (pair.getFirst() instanceof ClassParameter && !((ClassParameter)(object2 = (ClassParameter)pair.getFirst())).getRestrictionClass().equals(clazz) && ((ClassParameter)object2).getRestrictionClass().isAssignableFrom(clazz)) {
                        clazz = ((ClassParameter)object2).getRestrictionClass();
                    }
                    if (!(pair.getFirst() instanceof ClassListParameter) || ((ClassListParameter)(object2 = (ClassListParameter)pair.getFirst())).getRestrictionClass().equals(clazz) || !((ClassListParameter)object2).getRestrictionClass().isAssignableFrom(clazz)) continue;
                    clazz = ((ClassListParameter)object2).getRestrictionClass();
                }
                DocumentParameters.appendClassRestriction(document, clazz, element4);
            }
            DocumentParameters.appendDefaultValueIfSet(document, parameter, element4);
            if (clazz != null) {
                DocumentParameters.appendKnownImplementationsIfNonempty(document, clazz, element4);
            }
            node.appendChild(element4);
            Element element5 = document.createElement("ul");
            Element element6 = document.createElement("p");
            element6.appendChild(document.createTextNode(HEADER_PARAMETER_FOR));
            element4.appendChild(element6);
            element4.appendChild(element5);
            List<Pair<Parameter<?>, Class<?>>> object32 = map.get(optionID);
            Collections.sort(object32, comparator);
            object2 = object32.iterator();
            while (object2.hasNext()) {
                Pair pair = (Pair)object2.next();
                Element element7 = document.createElement("li");
                Object object3 = document.createElement("a");
                object3.setAttribute("href", DocumentParameters.linkForClassName(((Class)pair.getSecond()).getName()));
                object3.setTextContent(((Class)pair.getSecond()).getName());
                element7.appendChild((Node)object3);
                if (pair.getFirst() instanceof ClassParameter && parameter instanceof ClassParameter) {
                    object3 = (ClassParameter)pair.getFirst();
                    if (((ClassParameter)object3).getRestrictionClass() != null) {
                        if (!((ClassParameter)object3).getRestrictionClass().equals(clazz)) {
                            DocumentParameters.appendClassRestriction(document, ((ClassParameter)object3).getRestrictionClass(), element7);
                        }
                    } else {
                        DocumentParameters.appendNoClassRestriction(document, element7);
                    }
                }
                if ((object3 = (Parameter)pair.getFirst()).getDefaultValue() != null) {
                    if (!object3.getDefaultValue().equals(parameter.getDefaultValue())) {
                        DocumentParameters.appendDefaultValueIfSet(document, object3, element7);
                    }
                } else if (parameter.getDefaultValue() != null) {
                    DocumentParameters.appendNoDefaultValue(document, element7);
                }
                element5.appendChild(element7);
            }
        }
        return document;
    }

    private static void makeByOptOverviewWiki(Map<OptionID, List<Pair<Parameter<?>, Class<?>>>> map, WikiStream wikiStream) {
        ArrayList<OptionID> arrayList = new ArrayList<OptionID>(map.keySet());
        Collections.sort(arrayList, new SortByOption());
        for (OptionID optionID : arrayList) {
            Parameter<?> parameter = map.get(optionID).get(0).getFirst();
            wikiStream.indent = 1;
            wikiStream.printitem("");
            wikiStream.print("{{{");
            wikiStream.print("-");
            wikiStream.print(parameter.getName());
            wikiStream.print(" ");
            wikiStream.print(parameter.getSyntax());
            wikiStream.println("}}}:: ");
            wikiStream.newline = 1;
            wikiStream.indent = 2;
            DocumentParameters.appendMultilineTextWiki(wikiStream, parameter.getShortDescription());
            Class clazz = null;
            if (parameter instanceof ClassParameter) {
                clazz = ((ClassParameter)parameter).getRestrictionClass();
                for (Pair<Parameter<?>, Class<?>> pair : map.get(optionID)) {
                    ClassParameter classParameter = (ClassParameter)pair.getFirst();
                    if (classParameter.getRestrictionClass().equals(clazz) || !classParameter.getRestrictionClass().isAssignableFrom(clazz)) continue;
                    clazz = classParameter.getRestrictionClass();
                }
                DocumentParameters.appendClassRestrictionWiki(wikiStream, clazz);
            }
            if (!parameter.hasDefaultValue()) continue;
            DocumentParameters.appendDefaultValueWiki(wikiStream, parameter);
        }
    }

    private static void appendDefaultClassLink(Document document, Parameter<?> parameter, Element element) {
        Element element2 = document.createElement("a");
        element2.setAttribute("href", DocumentParameters.linkForClassName(((Class)((ClassParameter)parameter).getDefaultValue()).getCanonicalName()));
        element2.setTextContent(((Class)((ClassParameter)parameter).getDefaultValue()).getCanonicalName());
        element.appendChild(element2);
    }

    private static void appendClassRestriction(Document document, Class<?> clazz, Element element) {
        if (clazz == null) {
            LOG.warning("No restriction class!");
            return;
        }
        Element element2 = document.createElement("p");
        element2.appendChild(document.createTextNode(HEADER_CLASS_RESTRICTION));
        if (clazz.isInterface()) {
            element2.appendChild(document.createTextNode(HEADER_CLASS_RESTRICTION_IMPLEMENTING));
        } else {
            element2.appendChild(document.createTextNode(HEADER_CLASS_RESTRICTION_EXTENDING));
        }
        Element element3 = document.createElement("a");
        element3.setAttribute("href", DocumentParameters.linkForClassName(clazz.getName()));
        element3.setTextContent(clazz.getName());
        element2.appendChild(element3);
        element.appendChild(element2);
    }

    private static void appendNoClassRestriction(Document document, Element element) {
        Element element2 = document.createElement("p");
        element2.appendChild(document.createTextNode(HEADER_CLASS_RESTRICTION));
        element2.appendChild(document.createTextNode(NO_CLASS_RESTRICTION));
        element.appendChild(element2);
    }

    private static void appendClassRestrictionWiki(WikiStream wikiStream, Class<?> clazz) {
        if (clazz == null) {
            LOG.warning("No restriction class!");
            return;
        }
        wikiStream.print(HEADER_CLASS_RESTRICTION);
        if (clazz.isInterface()) {
            wikiStream.print(HEADER_CLASS_RESTRICTION_IMPLEMENTING);
        } else {
            wikiStream.print(HEADER_CLASS_RESTRICTION_EXTENDING);
        }
        wikiStream.javadocLink(clazz, null);
        wikiStream.println();
    }

    private static void appendNoClassRestrictionWiki(WikiStream wikiStream) {
        wikiStream.print(HEADER_CLASS_RESTRICTION);
        wikiStream.print(NO_CLASS_RESTRICTION);
        wikiStream.println();
    }

    private static void appendKnownImplementationsIfNonempty(Document document, Class<?> clazz, Element element) {
        List<Class<?>> list;
        if (clazz != Object.class && !(list = ELKIServiceRegistry.findAllImplementations(clazz)).isEmpty()) {
            Element element2 = document.createElement("p");
            element2.appendChild(document.createTextNode(HEADER_KNOWN_IMPLEMENTATIONS));
            element.appendChild(element2);
            Element element3 = document.createElement("ul");
            for (Class<?> clazz2 : list) {
                Element element4 = document.createElement("li");
                Element element5 = document.createElement("a");
                element5.setAttribute("href", DocumentParameters.linkForClassName(clazz2.getName()));
                element5.setTextContent(ClassParameter.canonicalClassName(clazz2, clazz));
                element4.appendChild(element5);
                element3.appendChild(element4);
            }
            element.appendChild(element3);
        }
    }

    private static void appendKnownImplementationsWiki(WikiStream wikiStream, Class<?> clazz) {
        List<Class<?>> list = ELKIServiceRegistry.findAllImplementations(clazz);
        if (list.size() == 0) {
            return;
        }
        wikiStream.println(HEADER_KNOWN_IMPLEMENTATIONS);
        ++wikiStream.indent;
        for (Class<?> clazz2 : list) {
            wikiStream.printitem("* ");
            wikiStream.javadocLink(clazz2, clazz);
            wikiStream.println();
        }
        --wikiStream.indent;
    }

    private static void appendDefaultValueIfSet(Document document, Parameter<?> parameter, Element element) {
        if (parameter.hasDefaultValue()) {
            Element element2 = document.createElement("p");
            element2.appendChild(document.createTextNode(HEADER_DEFAULT_VALUE));
            if (parameter instanceof ClassParameter) {
                DocumentParameters.appendDefaultClassLink(document, parameter, element2);
            } else if (parameter instanceof RandomParameter && parameter.getDefaultValue() == RandomFactory.DEFAULT) {
                element2.appendChild(document.createTextNode("use global random seed"));
            } else {
                element2.appendChild(document.createTextNode(parameter.getDefaultValueAsString()));
            }
            element.appendChild(element2);
        }
    }

    private static void appendNoDefaultValue(Document document, Element element) {
        Element element2 = document.createElement("p");
        element2.appendChild(document.createTextNode(HEADER_DEFAULT_VALUE));
        element2.appendChild(document.createTextNode(NO_DEFAULT_VALUE));
        element.appendChild(element2);
    }

    private static void appendDefaultValueWiki(WikiStream wikiStream, Parameter<?> parameter) {
        wikiStream.print(HEADER_DEFAULT_VALUE);
        if (parameter instanceof ClassParameter) {
            Class clazz = (Class)((ClassParameter)parameter).getDefaultValue();
            wikiStream.javadocLink(clazz, null);
        } else if (parameter instanceof RandomParameter && parameter.getDefaultValue() == RandomFactory.DEFAULT) {
            wikiStream.print("use global random seed");
        } else {
            wikiStream.print(parameter.getDefaultValueAsString());
        }
        wikiStream.println();
    }

    private static void appendNoDefaultValueWiki(WikiStream wikiStream) {
        wikiStream.print(HEADER_DEFAULT_VALUE);
        wikiStream.println(NO_DEFAULT_VALUE);
    }

    private static String linkForClassName(String string) {
        String string2 = string.replace(".", "/") + ".html";
        return string2;
    }

    protected static class SortByOption
    implements Comparator<OptionID> {
        protected SortByOption() {
        }

        @Override
        public int compare(OptionID optionID, OptionID optionID2) {
            return optionID.getName().compareToIgnoreCase(optionID2.getName());
        }
    }

    private static class WikiStream {
        PrintStream out;
        public int indent = 0;
        int newline = 0;

        WikiStream(PrintStream printStream) {
            this.out = printStream;
            this.newline = -1;
        }

        void print(String string) {
            this.insertNewline();
            this.out.print(string);
        }

        private void insertNewline() {
            if (this.newline == 2) {
                this.out.print("[[br]]");
            }
            if (this.newline != 0) {
                this.printIndent();
                this.newline = 0;
            }
        }

        private void printIndent() {
            if (this.newline > 0) {
                this.out.println();
            }
            for (int i = this.indent; i > 0; --i) {
                this.out.print(' ');
            }
        }

        void println(String string) {
            this.insertNewline();
            this.out.print(string);
            this.newline = 2;
        }

        void println() {
            this.newline = 2;
        }

        void printitem(String string) {
            this.printIndent();
            this.newline = 0;
            this.print(string);
        }

        void javadocLink(Class<?> clazz, Class<?> clazz2) {
            this.insertNewline();
            this.out.print("[[javadoc(");
            this.out.print(clazz.getCanonicalName());
            if (clazz2 != null) {
                this.out.print(",");
                this.out.print(ClassParameter.canonicalClassName(clazz, clazz2));
            }
            this.out.print(")]]");
        }
    }
}

