/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.ids.integer;

import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListMIter;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDPair;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.integer.DoubleIntegerDBIDPair;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDs;
import java.util.Arrays;

class DoubleIntegerDBIDPairList
implements ModifiableDoubleDBIDList,
IntegerDBIDs {
    int size;
    DoubleIntegerDBIDPair[] data;

    protected DoubleIntegerDBIDPairList() {
        this.data = new DoubleIntegerDBIDPair[21];
    }

    protected DoubleIntegerDBIDPairList(int n) {
        if (n > 0) {
            n = 21;
        }
        this.data = new DoubleIntegerDBIDPair[n];
    }

    @Override
    public Itr iter() {
        return new Itr();
    }

    @Override
    public boolean contains(DBIDRef dBIDRef) {
        int n = dBIDRef.internalGetIndex();
        for (int i = 0; i < this.size; ++i) {
            if (n != this.data[i].internalGetIndex()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public DoubleIntegerDBIDPair get(int n) {
        return this.data[n];
    }

    protected void addInternal(DoubleIntegerDBIDPair doubleIntegerDBIDPair) {
        if (this.size == this.data.length) {
            DoubleIntegerDBIDPair[] doubleIntegerDBIDPairArray = this.data;
            this.data = new DoubleIntegerDBIDPair[(this.data.length << 1) + 1];
            System.arraycopy(doubleIntegerDBIDPairArray, 0, this.data, 0, doubleIntegerDBIDPairArray.length);
        }
        this.data[this.size++] = doubleIntegerDBIDPair;
    }

    @Override
    public void add(double d, DBIDRef dBIDRef) {
        this.addInternal(new DoubleIntegerDBIDPair(d, dBIDRef.internalGetIndex()));
    }

    @Override
    public void add(DoubleDBIDPair doubleDBIDPair) {
        if (doubleDBIDPair instanceof DoubleIntegerDBIDPair) {
            this.addInternal((DoubleIntegerDBIDPair)doubleDBIDPair);
        } else {
            this.addInternal(new DoubleIntegerDBIDPair(doubleDBIDPair.doubleValue(), doubleDBIDPair.internalGetIndex()));
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.data, null);
        this.size = 0;
    }

    @Override
    public void sort() {
        Arrays.sort(this.data, 0, this.size);
    }

    protected void reverse() {
        int n = 0;
        for (int i = this.size - 1; n < i; ++n, --i) {
            DoubleIntegerDBIDPair doubleIntegerDBIDPair = this.data[i];
            this.data[i] = this.data[n];
            this.data[n] = doubleIntegerDBIDPair;
        }
    }

    @Override
    public void remove(int n) {
        if (n >= this.size) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (n < --this.size) {
            System.arraycopy(this.data, n + 1, this.data, n, this.size - n);
        }
        this.data[this.size] = null;
    }

    @Override
    public void removeSwap(int n) {
        if (n >= this.size) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (--this.size > 0) {
            this.data[n] = this.data[this.size];
        }
        this.data[this.size] = null;
    }

    @Override
    public void swap(int n, int n2) {
        DoubleIntegerDBIDPair doubleIntegerDBIDPair = this.data[n];
        this.data[n] = this.data[n2];
        this.data[n2] = doubleIntegerDBIDPair;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("kNNList[");
        Itr itr = this.iter();
        while (itr.valid()) {
            stringBuilder.append(itr.doubleValue()).append(':').append(itr.internalGetIndex());
            itr.advance();
            if (!itr.valid()) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private class Itr
    implements DoubleDBIDListMIter,
    IntegerDBIDArrayIter {
        int pos = 0;

        private Itr() {
        }

        @Override
        public boolean valid() {
            return this.pos < DoubleIntegerDBIDPairList.this.size && this.pos >= 0;
        }

        @Override
        public Itr advance() {
            ++this.pos;
            return this;
        }

        @Override
        public int getOffset() {
            return this.pos;
        }

        @Override
        public Itr advance(int n) {
            this.pos += n;
            return this;
        }

        @Override
        public Itr retract() {
            --this.pos;
            return this;
        }

        @Override
        public Itr seek(int n) {
            this.pos = n;
            return this;
        }

        @Override
        public int internalGetIndex() {
            return DoubleIntegerDBIDPairList.this.data[this.pos].internalGetIndex();
        }

        @Override
        public double doubleValue() {
            return DoubleIntegerDBIDPairList.this.data[this.pos].doubleValue();
        }

        @Override
        public void setDBID(DBIDRef dBIDRef) {
            DoubleIntegerDBIDPairList.this.data[this.pos].id = dBIDRef.internalGetIndex();
        }

        @Override
        public void setDouble(double d) {
            DoubleIntegerDBIDPairList.this.data[this.pos].value = d;
        }

        @Override
        public DoubleDBIDPair getPair() {
            return DoubleIntegerDBIDPairList.this.data[this.pos];
        }

        @Override
        public void remove() {
            DoubleIntegerDBIDPairList.this.remove(this.pos);
        }
    }
}

