/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.preprocessed.knn;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDPair;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.index.preprocessed.knn.AbstractMaterializeKNNPreprocessor;
import de.lmu.ifi.dbs.elki.index.tree.LeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialIndexTree;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialNode;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import gnu.trove.map.hash.TObjectDoubleHashMap;
import java.util.ArrayList;
import java.util.List;

@Title(value="Spatial Approximation Materialize kNN Preprocessor")
@Description(value="Caterializes the (approximate) k nearest neighbors of objects of a database using a spatial approximation.")
@Alias(value={"de.lmu.ifi.dbs.elki.preprocessing.SpatialApproximationMaterializeKNNPreprocessor"})
public class SpatialApproximationMaterializeKNNPreprocessor<O extends NumberVector, N extends SpatialNode<N, E>, E extends SpatialEntry>
extends AbstractMaterializeKNNPreprocessor<O> {
    private static final Logging LOG = Logging.getLogger(SpatialApproximationMaterializeKNNPreprocessor.class);

    public SpatialApproximationMaterializeKNNPreprocessor(Relation<O> relation, DistanceFunction<? super O> distanceFunction, int n) {
        super(relation, distanceFunction, n);
    }

    @Override
    protected void preprocess() {
        DistanceQuery distanceQuery = this.relation.getDistanceQuery(this.distanceFunction, new Object[0]);
        ArrayList<SpatialIndexTree> arrayList = ResultUtil.filterResults(this.relation.getHierarchy(), this.relation, SpatialIndexTree.class);
        if (arrayList.size() != 1) {
            throw new AbortException(SpatialApproximationMaterializeKNNPreprocessor.class.getSimpleName() + " found " + arrayList.size() + " spatial indexes, expected exactly one.");
        }
        SpatialIndexTree spatialIndexTree = (SpatialIndexTree)arrayList.iterator().next();
        this.storage = DataStoreUtil.makeStorage(this.relation.getDBIDs(), 4, KNNList.class);
        MeanVariance meanVariance = new MeanVariance();
        MeanVariance meanVariance2 = new MeanVariance();
        if (this.getLogger().isVerbose()) {
            this.getLogger().verbose("Approximating nearest neighbor lists to database objects");
        }
        List list = spatialIndexTree.getLeaves();
        FiniteProgress finiteProgress = this.getLogger().isVerbose() ? new FiniteProgress("Processing leaf nodes", list.size(), this.getLogger()) : null;
        for (SpatialEntry spatialEntry : list) {
            SpatialNode spatialNode = (SpatialNode)spatialIndexTree.getNode(spatialEntry);
            int n = spatialNode.getNumEntries();
            meanVariance.put(n);
            if (this.getLogger().isDebuggingFinest()) {
                this.getLogger().debugFinest("NumEntires = " + n);
            }
            ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray(n);
            for (int i = 0; i < n; ++i) {
                arrayModifiableDBIDs.add(((LeafEntry)spatialNode.getEntry(i)).getDBID());
            }
            TObjectDoubleHashMap<DBIDPair> tObjectDoubleHashMap = new TObjectDoubleHashMap<DBIDPair>(n * n * 3 >> 3, 0.5f, Double.NaN);
            DBIDArrayMIter dBIDArrayMIter = arrayModifiableDBIDs.iter();
            while (dBIDArrayMIter.valid()) {
                KNNHeap kNNHeap = DBIDUtil.newHeap(this.k);
                DBIDArrayMIter dBIDArrayMIter2 = arrayModifiableDBIDs.iter();
                while (dBIDArrayMIter2.valid()) {
                    DBIDPair dBIDPair = DBIDUtil.newPair(dBIDArrayMIter, (DBIDRef)dBIDArrayMIter2);
                    double d = tObjectDoubleHashMap.remove(dBIDPair);
                    if (d == d) {
                        kNNHeap.insert(d, dBIDArrayMIter2);
                    } else {
                        d = distanceQuery.distance((DBIDRef)dBIDArrayMIter, (DBIDRef)dBIDArrayMIter2);
                        kNNHeap.insert(d, dBIDArrayMIter2);
                        dBIDPair = DBIDUtil.newPair(dBIDArrayMIter2, (DBIDRef)dBIDArrayMIter);
                        tObjectDoubleHashMap.put(dBIDPair, d);
                    }
                    dBIDArrayMIter2.advance();
                }
                meanVariance2.put(kNNHeap.size());
                this.storage.put(dBIDArrayMIter, kNNHeap.toKNNList());
                dBIDArrayMIter.advance();
            }
            if (this.getLogger().isDebugging() && tObjectDoubleHashMap.size() > 0) {
                this.getLogger().warning("Cache should be empty after each run, but still has " + tObjectDoubleHashMap.size() + " elements.");
            }
            this.getLogger().incrementProcessed(finiteProgress);
        }
        this.getLogger().ensureCompleted(finiteProgress);
        if (this.getLogger().isVerbose()) {
            this.getLogger().verbose("Average page size = " + meanVariance.getMean() + " +- " + meanVariance.getSampleStddev());
            this.getLogger().verbose("On average, " + meanVariance2.getMean() + " +- " + meanVariance2.getSampleStddev() + " neighbors returned.");
        }
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public String getLongName() {
        return "Spatial Index Approximative kNN";
    }

    @Override
    public String getShortName() {
        return "spatial-approximate-knn";
    }

    @Override
    public void logStatistics() {
    }

    public static class Factory<N extends SpatialNode<N, E>, E extends SpatialEntry>
    extends AbstractMaterializeKNNPreprocessor.Factory<NumberVector> {
        public Factory(int n, DistanceFunction<? super NumberVector> distanceFunction) {
            super(n, distanceFunction);
        }

        @Override
        public SpatialApproximationMaterializeKNNPreprocessor<NumberVector, N, E> instantiate(Relation<NumberVector> relation) {
            SpatialApproximationMaterializeKNNPreprocessor spatialApproximationMaterializeKNNPreprocessor = new SpatialApproximationMaterializeKNNPreprocessor(relation, this.distanceFunction, this.k);
            return spatialApproximationMaterializeKNNPreprocessor;
        }

        public static class Parameterizer<N extends SpatialNode<N, E>, E extends SpatialEntry>
        extends AbstractMaterializeKNNPreprocessor.Factory.Parameterizer<NumberVector> {
            @Override
            protected Factory<N, E> makeInstance() {
                return new Factory(this.k, (DistanceFunction<? super NumberVector>)((DistanceFunction<NumberVector>)((DistanceFunction<? super NumberVector>)this.distanceFunction)));
            }
        }
    }
}

