/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.query;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.AbstractDistanceKNNQuery;
import de.lmu.ifi.dbs.elki.index.tree.DirectoryEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTree;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.MTreeEntry;
import de.lmu.ifi.dbs.elki.index.tree.query.DoubleMTreeDistanceSearchCandidate;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.ComparableMinHeap;

public class MetricalIndexKNNQuery<O>
extends AbstractDistanceKNNQuery<O> {
    protected final AbstractMTree<O, ?, ?, ?> index;

    public MetricalIndexKNNQuery(AbstractMTree<O, ?, ?, ?> abstractMTree, DistanceQuery<O> distanceQuery) {
        super(distanceQuery);
        this.index = abstractMTree;
    }

    @Override
    public KNNList getKNNForObject(O o, int n) {
        if (n < 1) {
            throw new IllegalArgumentException("At least one object has to be requested!");
        }
        this.index.statistics.countKNNQuery();
        KNNHeap kNNHeap = DBIDUtil.newHeap(n);
        double d = Double.POSITIVE_INFINITY;
        ComparableMinHeap<DoubleMTreeDistanceSearchCandidate> comparableMinHeap = new ComparableMinHeap<DoubleMTreeDistanceSearchCandidate>();
        comparableMinHeap.add(new DoubleMTreeDistanceSearchCandidate(0.0, this.index.getRootID(), null, 0.0));
        while (!comparableMinHeap.isEmpty()) {
            double d2;
            double d3;
            double d4;
            DBID dBID;
            MTreeEntry mTreeEntry;
            int n2;
            DoubleMTreeDistanceSearchCandidate doubleMTreeDistanceSearchCandidate = (DoubleMTreeDistanceSearchCandidate)comparableMinHeap.poll();
            if (kNNHeap.size() >= n && doubleMTreeDistanceSearchCandidate.mindist > d) break;
            AbstractMTreeNode abstractMTreeNode = (AbstractMTreeNode)this.index.getNode(doubleMTreeDistanceSearchCandidate.nodeID);
            DBID dBID2 = doubleMTreeDistanceSearchCandidate.routingObjectID;
            double d5 = doubleMTreeDistanceSearchCandidate.routingDistance;
            if (!abstractMTreeNode.isLeaf()) {
                for (n2 = 0; n2 < abstractMTreeNode.getNumEntries(); ++n2) {
                    double d6;
                    mTreeEntry = (MTreeEntry)abstractMTreeNode.getEntry(n2);
                    dBID = mTreeEntry.getRoutingObjectID();
                    d4 = mTreeEntry.getCoveringRadius();
                    d3 = dBID2 != null ? mTreeEntry.getParentDistance() : 0.0;
                    d2 = Math.abs(d5 - d3);
                    if (!(d2 <= (d6 = d + d4))) continue;
                    double d7 = this.distanceQuery.distance(dBID, o);
                    this.index.statistics.countDistanceCalculation();
                    double d8 = Math.max(d7 - d4, 0.0);
                    if (!(d8 <= d)) continue;
                    comparableMinHeap.add(new DoubleMTreeDistanceSearchCandidate(d8, ((DirectoryEntry)((Object)mTreeEntry)).getPageID(), dBID, d7));
                }
                continue;
            }
            for (n2 = 0; n2 < abstractMTreeNode.getNumEntries(); ++n2) {
                mTreeEntry = (MTreeEntry)abstractMTreeNode.getEntry(n2);
                dBID = mTreeEntry.getRoutingObjectID();
                d4 = dBID2 != null ? mTreeEntry.getParentDistance() : 0.0;
                d3 = Math.abs(d5 - d4);
                if (!(d3 <= d)) continue;
                d2 = this.distanceQuery.distance(dBID, o);
                this.index.statistics.countDistanceCalculation();
                if (!(d2 <= d)) continue;
                kNNHeap.insert(d2, dBID);
                d = kNNHeap.getKNNDistance();
            }
        }
        return kNNHeap.toKNNList();
    }
}

