/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.geodesy;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.geodesy.EarthModel;
import de.lmu.ifi.dbs.elki.math.geodesy.SphereUtil;

public abstract class AbstractEarthModel
implements EarthModel {
    private static final int MAX_ITER = 20;
    private static final double PRECISION = 1.0E-10;
    final double a;
    final double b;
    final double f;
    final double invf;
    final double e;
    final double esq;

    public AbstractEarthModel(double d, double d2, double d3, double d4) {
        this.a = d;
        this.b = d2;
        this.f = d3;
        this.invf = d4;
        this.esq = d3 * (2.0 - d3);
        this.e = Math.sqrt(this.esq);
    }

    @Override
    public double getEquatorialRadius() {
        return this.a;
    }

    @Override
    public double getPolarDistance() {
        return this.b;
    }

    @Override
    public double[] latLngDegToECEF(double d, double d2) {
        return this.latLngRadToECEF(MathUtil.deg2rad(d), MathUtil.deg2rad(d2));
    }

    @Override
    public double[] latLngDegToECEF(double d, double d2, double d3) {
        return this.latLngRadToECEF(MathUtil.deg2rad(d), MathUtil.deg2rad(d2), d3);
    }

    @Override
    public double[] latLngRadToECEF(double d, double d2) {
        double d3 = Math.cos(d);
        double d4 = MathUtil.cosToSin(d, d3);
        double d5 = Math.cos(d2);
        double d6 = MathUtil.cosToSin(d2, d5);
        double d7 = this.a / Math.sqrt(1.0 - this.esq * d4 * d4);
        return new double[]{d7 * d3 * d5, d7 * d3 * d6, (1.0 - this.esq) * d7 * d4};
    }

    @Override
    public double[] latLngRadToECEF(double d, double d2, double d3) {
        double d4 = Math.cos(d);
        double d5 = MathUtil.cosToSin(d, d4);
        double d6 = Math.cos(d2);
        double d7 = MathUtil.cosToSin(d2, d6);
        double d8 = this.a / Math.sqrt(1.0 - this.esq * d5 * d5);
        return new double[]{(d8 + d3) * d4 * d6, (d8 + d3) * d4 * d7, ((1.0 - this.esq) * d8 + d3) * d5};
    }

    @Override
    public double ecefToLatDeg(double d, double d2, double d3) {
        return MathUtil.rad2deg(this.ecefToLatRad(d, d2, d3));
    }

    @Override
    public double ecefToLatRad(double d, double d2, double d3) {
        double d4 = Math.sqrt(d * d + d2 * d2);
        double d5 = Math.atan2(d3, d4 * (1.0 - this.esq));
        int n = 0;
        double d6;
        double d7;
        double d8;
        while (!(Math.abs((d8 = Math.atan2(d3 + this.esq * (d7 = this.a / Math.sqrt(1.0 - this.esq * (d6 = Math.sin(d5)) * d6)) * d6, d4)) - d5) < 1.0E-10) && n <= 20) {
            d5 = d8;
            ++n;
        }
        return d8;
    }

    @Override
    public double ecefToLngDeg(double d, double d2) {
        return MathUtil.rad2deg(this.ecefToLngRad(d, d2));
    }

    @Override
    public double ecefToLngRad(double d, double d2) {
        return Math.atan2(d2, d);
    }

    @Override
    public double[] ecefToLatLngDegHeight(double d, double d2, double d3) {
        double[] dArray = this.ecefToLatLngRadHeight(d, d2, d3);
        dArray[0] = MathUtil.rad2deg(dArray[0]);
        dArray[1] = MathUtil.rad2deg(dArray[1]);
        return dArray;
    }

    @Override
    public double[] ecefToLatLngRadHeight(double d, double d2, double d3) {
        double d4 = Math.atan2(d2, d);
        double d5 = Math.sqrt(d * d + d2 * d2);
        double d6 = Math.atan2(d3, d5 * (1.0 - this.esq));
        double d7 = 0.0;
        int n = 0;
        while (true) {
            double d8;
            double d9;
            double d10;
            if (Math.abs((d10 = Math.atan2(d3 + this.esq * (d9 = this.a / Math.sqrt(1.0 - this.esq * (d8 = Math.sin(d6)) * d8)) * d8, d5)) - d6) < 1.0E-10 || n > 20) {
                d7 = d5 / Math.cos(d10) - d9;
                return new double[]{d10, d4, d7};
            }
            d6 = d10;
            ++n;
        }
    }

    @Override
    public double distanceDeg(double d, double d2, double d3, double d4) {
        return this.distanceRad(MathUtil.deg2rad(d), MathUtil.deg2rad(d2), MathUtil.deg2rad(d3), MathUtil.deg2rad(d4));
    }

    @Override
    public double distanceRad(double d, double d2, double d3, double d4) {
        return this.b * SphereUtil.ellipsoidVincentyFormulaRad(this.f, d, d2, d3, d4);
    }

    @Override
    public double minDistDeg(double d, double d2, double d3, double d4, double d5, double d6) {
        return this.minDistRad(MathUtil.deg2rad(d), MathUtil.deg2rad(d2), MathUtil.deg2rad(d3), MathUtil.deg2rad(d4), MathUtil.deg2rad(d5), MathUtil.deg2rad(d6));
    }

    @Override
    public double minDistRad(double d, double d2, double d3, double d4, double d5, double d6) {
        return this.b * SphereUtil.latlngMinDistRad(d, d2, d3, d4, d5, d6);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [a=" + this.a + ", b=" + this.b + ", f=" + this.f + ", invf=" + this.invf + ", e=" + this.e + ", esq=" + this.esq + "]";
    }
}

