/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.Distribution;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;

public class ConstantDistribution
implements Distribution {
    final double c;

    public ConstantDistribution(double d) {
        this.c = d;
    }

    @Override
    public double nextRandom() {
        return this.c;
    }

    @Override
    public double pdf(double d) {
        return d == this.c ? 1.0 : 0.0;
    }

    @Override
    public double cdf(double d) {
        return this.c < d ? 0.0 : (this.c > d ? 1.0 : 0.5);
    }

    @Override
    public double quantile(double d) {
        return this.c;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID CONSTANT_ID = new OptionID("distribution.constant", "Constant value.");
        double constant;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter = new DoubleParameter(CONSTANT_ID);
            if (parameterization.grab(doubleParameter)) {
                this.constant = doubleParameter.doubleValue();
            }
        }

        @Override
        protected ConstantDistribution makeInstance() {
            return new ConstantDistribution(this.constant);
        }
    }
}

