/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.result.outlier;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierScoreMeta;

public class BasicOutlierScoreMeta
implements OutlierScoreMeta {
    double actualMinimum = Double.NaN;
    double actualMaximum = Double.NaN;
    double theoreticalMinimum = Double.NaN;
    double theoreticalMaximum = Double.NaN;
    double theoreticalBaseline = Double.NaN;

    public BasicOutlierScoreMeta(double d, double d2) {
        this(d, d2, Double.NaN, Double.NaN, Double.NaN);
    }

    public BasicOutlierScoreMeta(double d, double d2, double d3, double d4) {
        this(d, d2, d3, d4, Double.NaN);
    }

    public BasicOutlierScoreMeta(double d, double d2, double d3, double d4, double d5) {
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            Logging.getLogger(this.getClass()).warning("Warning: Outlier Score meta initalized with NaN values: " + d + " - " + d2);
        }
        this.actualMinimum = d;
        this.actualMaximum = d2;
        this.theoreticalMinimum = d3;
        this.theoreticalMaximum = d4;
        this.theoreticalBaseline = d5;
    }

    @Override
    public double getActualMaximum() {
        return this.actualMaximum;
    }

    @Override
    public double getActualMinimum() {
        return this.actualMinimum;
    }

    @Override
    public double getTheoreticalBaseline() {
        return this.theoreticalBaseline;
    }

    @Override
    public double getTheoreticalMaximum() {
        return this.theoreticalMaximum;
    }

    @Override
    public double getTheoreticalMinimum() {
        return this.theoreticalMinimum;
    }

    @Override
    public double normalizeScore(double d) {
        double d2 = 0.0;
        if (!Double.isNaN(this.theoreticalBaseline) && !Double.isInfinite(this.theoreticalBaseline)) {
            d2 = this.theoreticalBaseline;
        } else if (!Double.isNaN(this.theoreticalMinimum) && !Double.isInfinite(this.theoreticalMinimum)) {
            d2 = this.theoreticalMinimum;
        } else if (!Double.isNaN(this.actualMinimum) && !Double.isInfinite(this.actualMinimum)) {
            d2 = this.actualMinimum;
        }
        if (d < d2) {
            return 0.0;
        }
        double d3 = Double.NaN;
        if (!Double.isNaN(this.theoreticalMaximum) && !Double.isInfinite(this.theoreticalMaximum)) {
            d3 = this.theoreticalMaximum;
        } else if (!Double.isNaN(this.actualMaximum) && !Double.isInfinite(this.actualMaximum)) {
            d3 = this.actualMaximum;
        }
        if (!Double.isNaN(d3) && !Double.isInfinite(d3) && d3 >= d2) {
            return (d - d2) / (d3 - d2);
        }
        return d - d2;
    }

    public void setActualMinimum(double d) {
        this.actualMinimum = d;
    }

    public void setActualMaximum(double d) {
        this.actualMaximum = d;
    }

    @Override
    public String getLongName() {
        return "Outlier Score Metadata";
    }

    @Override
    public String getShortName() {
        return "outlier-score-meta";
    }
}

